<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Global Class Manager
 *
 * @class   RDS_WP_Global_Helper
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_WP_Global_Helper' ) ) {
	class RDS_WP_Global_Helper {

		// Singleton control
		protected static $instance = false; 
		public static function get_instance() { 
			return self::$instance ? self::$instance : (self::$instance = new self());
		}


	    /**
	     * Get Current Date Time Format
	     *
	     * @access public
	     * @param string $version
	     * @return date time
	     */
	    public static function RDS__get_current_date_time_format($value = null)
	    {	
	        $date   = new DateTime();
            return $date->format('Y-m-d H:i:s');
	    }

		/**
	     * Get Date Time Format
	     *
	     * @access public
	     * @param string $version
	     * @return date time
	     */
	    public static function RDS__get_date_time_format($value = null)
	    {	
	        $date   = new DateTime($value);
            return $date->format('Y-m-d H:i:s');
	    }

		/**
	     * Get Date Time Format (Y-m-d H:i:s A)
	     *
	     * @access public
	     * @param string $version
	     * @return date time
	     */
	    public static function RDS__get_date_time_new_format($value = null)
	    {	
	        $date   = new DateTime($value);
            return $date->format('Y-m-d H:i:s A');
	    }


		/**
	     * Get License Details from WP options table.
	     *
	     * @access public
	     * @param string $version
	     * @return object/array
	     */
	    public static function RDS__get_license_details( )
	    {	
	        return get_option('rds_license', true);
	    }

		/**
	     * Get Shipping Total Cost
	     *
	     * @access public
	     * @param string $version
	     * @return cost
	     */
	    public static function RDS__pc_get_shipping(){
            $ret = 0.00;
            if(!empty(WC()->session->get('shipping_for_package_0')['rates'])){
                foreach( WC()->session->get('shipping_for_package_0')['rates'] as $method_id => $rate ){
                    if( WC()->session->get('chosen_shipping_methods')[0] == $method_id ){
                        $ret = WC()->cart->get_cart_shipping_total();
                    } 
                }
            }
            return $ret;
        }

	}

	$RDS_WP_Global_Helper = new RDS_WP_Global_Helper();
}