<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Helper Class Manager
 *
 * @class   RDS_WC_Helper
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_WC_Helper' ) ) {
	class RDS_WC_Helper {

		// Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }

		/**
	     * Check WooCommerce version
	     *
	     * @access public
	     * @param string $version
	     * @return bool
	     */
		public static function wc_version_get( $version )
		{	
			if (defined('WC_VERSION') && WC_VERSION) {
				return version_compare(WC_VERSION, $version, '>=');
			}
			else if (defined('WOOCOMMERCE_VERSION') && WOOCOMMERCE_VERSION) {
				return version_compare(WOOCOMMERCE_VERSION, $version, '>=');
			} else {
				return false;
			}
		}

		public static function check_product_item_description_status( $product, $arr_product )
		{	
			$status = true;
			if( empty($product->get_width()) && empty($product->get_height()) &&  empty($product->get_length()) && empty($product->get_weight()) )
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product items width, height, length and weight. Please contact to administator before checkout.' ), 'error' );
				$status = false;
			} 
			else if( empty($product->get_width()) ) 
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item width, please contact to administator before checkout.' ), 'error' );
				$status = false;
			} 
			else if( empty($product->get_height()) ) 
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item height, please contact to administator before checkout.' ), 'error' );   
				$status = false;    
			} 
			else if ( empty($product->get_length()) ) 
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item length, please contact to administator before checkout.' ), 'error' );
				$status = false;
			} 
			else if( empty($product->get_weight()) ) 
			{    
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item weight, please contact to administator before checkout.' ), 'error' );
				$status = false;
			}


			if($status === false){
				if(is_cart()){
					remove_action( 'woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20);
				}
				if(is_checkout()){
					add_filter('woocommerce_order_button_html', 'RDS__inactive_order_button_html' );
				}
			}
		}

		public static function RDS__get_notice_error_message( $option_value )
		{	
			$msg = '';			
			if( empty($option_value['key']) || empty($option_value['token']) ) 
			{ 
				$msg = '<div class="error"><p>' . sprintf(esc_html__('You have to activate your license for this plugin %1$s. ', 'rds_wc_shipment_class'), '<strong>'. RDSWC_PLUGINNAME .'</strong>') . sprintf(esc_html__('If your plugin havn\'t licensed then you miss all the features of it.', 'rds_wc_shipment_class')) . '</p></div>';
			} 
			return $msg;
		}

		public static function RDS__find_plugin_folder_name($path){
			$arr = explode("/", $path);
            $folder_name = '';
            foreach($arr as $index => $val) {
                if (strpos($val, 'wc-roadie-shipping') !== false) {
                    $folder_name = $arr[$index];
                }
            }
            return $folder_name;
		}


        public function RDS__decipher($encipher_str, $pwd, $encoding = null) 
        {
            if ($encipher_str != null && $pwd != null) {
                $encipher_str = $encoding == "hex" ? hex2bin($encipher_str) : ($encoding == "base64" ? base64_decode($encipher_str) : $encipher_str);
                $keysalt = substr($encipher_str, 0, 16);
                $key = hash_pbkdf2("sha512", $pwd, $keysalt, 20000, 32, true);
                $ivlength = openssl_cipher_iv_length("aes-256-gcm");
                $iv = substr($encipher_str, 16, $ivlength);
                $tag = substr($encipher_str, -16);
                return openssl_decrypt(substr($encipher_str, 16 + $ivlength, -16), "aes-256-gcm", $key, OPENSSL_RAW_DATA, $iv, $tag);
            }
        }


	}

	$RDS_WC_Helper = new RDS_WC_Helper();


	function RDS__inactive_order_button_html( $button ) {
		$order_button_text = __('Place Order', 'woocommerce');
		$button = '<input type="button" disabled class="button alt" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '"/>';
		return $button;
	}
}