<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Webhook Helper Class
 *
 * @class   RDS_Webhook_Helper
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_Webhook_Helper' ) ) {
	class RDS_Webhook_Helper {


		// Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }

		/**
	     * Get Roadie Shipping events
	     *
	     * @access public
	     * @param string $version
	     * @return string
	     */
	    public static function get_shipping_events($event_code)
	    {	
	        switch ($event_code) {
		      case "driver_assigned":
		        return "Driver assigned.";
		        break;
		      case "en_route_to_pickup":
		        return  "Driver headed to pickup location.";
		        break;
		      case "at_pickup":
		        return  "Driver at the pickup location.";
		        break;
		      case "pickup_confirmed":
		        return  "Picked up the shipment.";
		        break;
		      case "en_route_to_delivery":
		        return  "Driver headed to delivery location.";
		        break;
		      case "at_delivery":
		        return  "Driver at the delivery location.";
		        break;
		      case "delivery_confirmed":
		        return  "Driver delivered the shipment. ";
		        break;
		      case "delivery_details_added":
		        return  "Driver submitted delivery photo.";
		        break;
		      case "delivery_attempted":
		        return  "Unsuccessful in delivering the shipment.";
		        break;
		      case "returned":
		        return  "Shipment was undeliverable and returned.";
		        break;
		      case "canceled":
		        return  "The shipment has been canceled.";
		        break;
		      case "approaching_pickup":
		        return  "Driver near the pickup location.";
		        break;
		      case "approaching_delivery":
		        return  "Driver near the delivery location.";
		        break;
		      default:
		        return  "N/A";
		    }
	    }

		/**
	     * Get Roadie Shipping Status Color Name
	     *
	     * @access public
	     * @param string $version
	     * @return string
	     */
	    public static function get_status_color_name($status)
	    {	
	        switch ($status) {
		      case "scheduled":
		        return "warning";;
		        break;
		      case "assigned":
		        return  "info";
		        break;
		      case "en_route":
		        return  "primary";
		        break;
		      case "delivered":
		        return  "success";
		        break;
		      case "attempted":
		        return  "primary";
		        break;
		      case "returned":
		        return  "warning";
		        break;
		      case "canceled":
		        return  "danger";
		        break;
		      case "expired":
		        return  "danger";
		        break;
		      default:
		        return  "primary";
		    }
	    }

	}

	$RDS_Webhook_Helper = new RDS_Webhook_Helper();
}