<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Plugin Upgrade Class 
 *
 * @class   RDS_PLGN_Upgrade_Manager
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_PLGN_Upgrade_Manager' ) ) {
	class RDS_PLGN_Upgrade_Manager { 

        // Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }

        private static $menu_slug;

        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {   
            self::$menu_slug = 'admin.php?page=roadie-shipping';

            add_action('admin_menu', [ $this, 'RDS__add_plugin_options_page'] );

            add_action('admin_enqueue_scripts', [ $this, 'RDS__load_wp_admin_style' ] );

            add_action('admin_init', [ $this, 'RDS__register_plugin_settings' ] );
        }

        public static function RDS__add_plugin_options_page()
        {
            add_menu_page( 
                __( 'Plugin License', 'rds_wc_shipment_class' ),
                'Roadie Shipping',
                'manage_options',
                self::$menu_slug,
                '',
                RDSWC_URL .'includes/assets/rds-icon.png',
                90
            );
            add_submenu_page( 
                self::$menu_slug, 
                __( 'Settings', 'rds_wc_shipment_class' ),
                'Settings', 
                'read', 
                'admin.php?page=wc-settings&tab=shipping&section=roadies', 
                '' 
            );

            add_submenu_page(
                self::$menu_slug,               
                'Plugin License',                      
                'Plugin License',                      
                'manage_options',                   
                'roadie-shipping-license',               
                [self::$instance, 'RDS__activate_plugin_license'] 
            );

            // Delete plugin primary menu item name.
            global $submenu;
            unset( $submenu['admin.php?page=roadie-shipping'][0] ); 
        }

        public function RDS__load_wp_admin_style(){

            wp_enqueue_style( 'jquery-select2', "https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" ); 
            wp_enqueue_script( 'jquery-select2-script', "https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js", array(), '0.9.12', true );
            
            wp_enqueue_style( 'rds-admin-style', RDSWC_URL . "includes/assets/css/admin-style.css", false, '1.0.0', 'all' );
            wp_enqueue_script( 'roadie-admin-script', RDSWC_URL . "includes/assets/js/rds-admin.js", array(), '1.0.0', true ); 
        }

        public function RDS__activate_plugin_license()
        {   
            require_once( RDSWC_PATH . '/includes/views/backend/rds-plugin-validation.php' );
        }

        public function RDS__register_plugin_settings()
        {   
            if( isset( $_POST['rds_license_activate'] ) ) {               
                register_setting('rds', 'rds_license', [$this, 'RDS__authentications_callback']);
            }
           
        }
        public function RDS__authentications_callback($options) {
            if (empty($options['key']) && empty($options['secret_key'])) { 
                add_settings_error('rds_license', esc_attr('rds_notice'), 'License key & secret key are required.', 'error');
                return false;
            } else if (empty($options['key'])) {
                add_settings_error('rds_license', esc_attr('rds_notice'), 'License key is required.', 'error');
                return false;
            } else if(empty($options['secret_key'])) {
                add_settings_error('rds_license', esc_attr('rds_notice'), 'Secret key is required.', 'error');
                return false;
            } else {
            
                // if ($cache !== null) {
                //   return $cache;
                // }

                //RDS_WC_Helper::RDS__decipher();
                          
                $plugin_name = basename( plugin_dir_path(  dirname( __FILE__ , 2 ) ) );
                $urlparts    = parse_url(home_url());  

                $postData = [
                    "plugin_name"       => ucwords(str_replace("-", " ", $plugin_name)),
                    "activation_key"    => $options['key'],
                    "activation_token"  => $options['secret_key'],
                    "ip_address"        => getHostByName(getHostName()),
                    "plan"              => 2,
                    "system_name"       => php_uname('s'),
                    "site_name"         => $urlparts['host'],
                    "created_on"        => date('Y-m-d H:i:s'),
                ];

                $api_url = RDSWC_APIURL.'/product/verifications';
                $res     = $this->RDS__validate_license_key($api_url, $postData);
                
                if($res['status'] === false && empty($res['data'])){
                    $plugin_name = $res['data']['plugin_name'];
                    // add_settings_error('rds_license', esc_attr('settings_updated'), $res['msg'], 'error');
                }

                $plugin_status = 0;
                if(!empty($res['status'])){
                    $plugin_status    = $res['data']['status'];
                    $activation_key   = $res['data']['activation_key'];
                    $activation_token = $res['data']['activation_token'];
                    $ip_address       = $res['data']['ip_address'];
                } 
                $cache = [
                  'key'         => $activation_key,
                  'token'       => $activation_token,
                  'status'      => $plugin_status,
                  'msg'         => $res['msg'],
                  'plugin_name' => $plugin_name,
                  'ip_address'  => $ip_address
                ];

                return $cache;
            }
        }   

        public function RDS__validate_license_key($api_url, $postData){
            $apiOptions = [
                'body'        => json_encode($postData),
                'headers'     => [
                    'Content-Type' => 'application/json',
                    // 'Authorization' => $api_details['api_request_headers'],
                ],
            ]; 
            $request = wp_remote_post( $api_url , $apiOptions ); 
            if(wp_remote_retrieve_response_code( $request ) == 200){           
                $response = wp_remote_retrieve_body( $request );
            } else {         
                $response = wp_remote_retrieve_body( $request );                
            } 
            return json_decode($response, true);
        }

    }

    RDS_PLGN_Upgrade_Manager::get_instance();
}
