<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Load Class 
 *
 * @class   RDS_Load_File_Manager
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_Load_File_Manager' ) ) {
	class RDS_Load_File_Manager {
		
        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {
			// Load Custom Helper Class
         	require_once( RDSWC_PATH . '/classes/helper/rds-helper-class.php' );
         	require_once( RDSWC_PATH . '/classes/helper/rds-webhook-helper-class.php' );

            // Load Custom Global Class
	        require_once( RDSWC_PATH . '/classes/global/rds-global-class.php' );
	        require_once( RDSWC_PATH . '/classes/global/rds-db-query-result-class.php' );

	        // Load Roadie shipping settings method class and Admin settings
	        require_once( RDSWC_PATH . '/classes/rds-wc-shipping-method-setting-class.php' );
	        require_once( RDSWC_PATH . '/classes/rds-wc-admin-order-shipment-managment-class.php' );

	        // Load Upgration Class
	        require_once( RDSWC_PATH . '/classes/wp-essential/rds-plugin-upgradation.php' );

	        // Load Roadie Shipping API enpoints and initializations
	        require_once( RDSWC_PATH . '/classes/api/rds-api-initialization-class.php' );  

	        // Load other WC hooks
	        require_once( RDSWC_PATH . '/includes/wp-hooks/hooks.php' ); 

	        // Load Cron Job
	        require_once( RDSWC_PATH . '/schedulers/rds-scheduler.php' ); 
        }

	}

	$RDS_Load_File_Manager = new RDS_Load_File_Manager();
}