<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Load Checkout Page Hooks 
 *
 * @class   RDS_Enable_Checkout_Hook
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_Enable_Checkout_Hook' ) ) {
	class RDS_Enable_Checkout_Hook {
		
        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {   
            add_action( 'woocommerce_review_order_before_order_total', [ $this, 'RDS__checkout_review_order_custom_field' ] );

            add_filter( 'woocommerce_checkout_fields', [ $this, 'RDS__wc_billing_fields' ] );
			
            add_action('woocommerce_checkout_process', [ $this, 'RDS__custom_validate_billing_phone' ] );

            add_action( 'wp_footer', [ $this, 'RDS__add_wc_checkout_page_script' ], 99 );

            add_action( 'woocommerce_before_checkout_form', [ $this, 'RDS__add_driver_tip_section_on_checkout' ], 11 );

            add_action( 'woocommerce_before_calculate_totals', [ $this, 'RDS__wc_add_driver_to_total_price' ], 10 );

            add_filter('woocommerce_after_checkout_form', [ $this, 'RDS__remove_fields_on_checkout_page' ] );

        }


        /**
         * Add this action to shipping method error and shipping cost after check from the Roadie Api.
         * **/
        public static function RDS__checkout_review_order_custom_field( ) 
        {
            global $woocommerce;
            $shipping_cost      = RDS_WP_Global_Helper::RDS__pc_get_shipping();
            $status             = true; 
            $shipping_address   = $woocommerce->customer->get_shipping_address();
            $shipping_postcode  = $woocommerce->customer->get_shipping_postcode();
            $shipping_city      = $woocommerce->customer->get_shipping_city(); 
            $shipping_state     = $woocommerce->customer->get_shipping_state(); 

            if(empty($shipping_address) && empty($shipping_city) && empty($shipping_postcode)){        
                $status = false; 
            } else if(empty($shipping_address)){
                $status = false; 
            } else if(empty($shipping_city)){
                $status = false; 
            } else if(empty($shipping_postcode)){
                $status = false; 
            } else {
                $status = true; 
            }

            if(WC()->session->get('chosen_shipping_methods')[0] == 'roadies'){
                if($shipping_cost == 'Free!'){
                    if($status === true){
                        $shipping_cost = '<span class="shipping_err">Sorry, We are not provide our service in this area.</span>';
                        echo "<style>.woocommerce-checkout-payment button{pointer-events: none; background-color: #ccc !important; color: #9d9d9d !important;}</style>";
                    } else {
                        $shipping_cost = "$".number_format(0, 2);
                    }
                } 
            } else if(!is_numeric($shipping_cost) && $shipping_cost == 'Free!'){
                $shipping_cost = "$".number_format(0, 2);
            }
            echo '<tr><th><strong>Delivery Fee </strong></th><td>'.$shipping_cost.'</td></tr>';
        }


        /**
         * Add this action for custom validation for phone number on checkout page.
         * **/
        public static function RDS__custom_validate_billing_phone() 
        {
            $is_correct = preg_match('/^[0-9]{10,12}$/', $_POST['billing_phone']);
            if ( $_POST['billing_phone'] && !$is_correct) {
                wc_add_notice( __( 'The Phone field should be <strong>between 10 and 12 digits</strong>.' ), 'error' );
            }
        }


        /**
         * Add this action for custom delivery date field on woocommerce checkout page.
         * **/
        public static function RDS__wc_billing_fields( $fields ) 
        {   
            $fields['billing']['rds_billing_delivery_date'] = [
                'type'        => 'text', 
                'label'       => __('Delivery Date & Time', 'woocommerce'),
                'placeholder' => __('yyyy/mm/dd HH:ii', 'woocommerce'),
                'required'    => true, 
                'clear'       => true, 
                'class'       => array('rds_delivery_date_time'),  
                'priority'    => 90, 
                'autocomplete'=> 'none',
            ];
            return $fields;
        }


        /**
         * Add this script file for validating the Delivery date & time
         * **/
        public static function RDS__add_wc_checkout_page_script() 
        {
            if (is_checkout()) {
                $shipping_admin_details = get_option("woocommerce_roadies_settings", true);
                
                require_once( RDSWC_PATH . '/includes/views/frontend/checkout-page/delivery-date-time-script.php' );  
            }
        }


        /**
         * Create a section to enter the driver tip amount.
         * **/
        public static function RDS__add_driver_tip_section_on_checkout() 
        { 
            $shipping_admin_details   = get_option("woocommerce_roadies_settings", true);  
            if($shipping_admin_details['enabled'] == 'yes'){
                require_once( RDSWC_PATH . '/includes/views/frontend/checkout-page/driver_tip.php');  
                
                // checks if submitted fields are empty and adds error
                if ( empty( $_POST['tip_amount'] ) && isset( $_POST['tip_amount'] ) ) {
                    echo '<div class="woocommerce-notices-wrapper woocommerce-error"><span> Please enter tip amount. </span></div>'; 
                    update_option('roadie_tip_amount', 0.00 );
                }
                if ( !empty( $_POST['tip_amount'] ) && isset( $_POST['tip_amount'] ) ) { 
                    update_option('roadie_tip_amount', $_POST['tip_amount'] );
                    global $woocommerce;
                    $woocommerce->session->set("roadie_tip_amount", $_POST['tip_amount']);
                    echo '<div class="woocommerce-message woocommerce-success"> Tip added successfully </div>';
                }
            }
        }


        /**
         * This action adjust the tip amount to order total price.
         * **/
        public static function RDS__wc_add_driver_to_total_price() 
        {
            global $woocommerce; 
            if(is_cart()){
                if(get_option('roadie_tip_amount')){
                    update_option('roadie_tip_amount', 0.00 );
                }
            } else if(is_checkout()){
                if ( get_option('roadie_tip_amount') ) { 
                    $fee_name    = 'Tip for the Driver';
                    $user_charge = get_option('roadie_tip_amount');    
                    $woocommerce->cart->add_fee( $fee_name, $user_charge, false, '' );   
                }
            }
        }


        /**
         * Add this filter to remove Delivery date & time fields and Tip section after choose different shipping method.
         * **/
        public static function RDS__remove_fields_on_checkout_page() 
        {
            global $woocommerce; 
            if(WC()->session->get('chosen_shipping_methods')[0] != 'roadies'){
                $events = '.slideUp()';
            } else {
                $events = '.slideDown()';
            }
            wc_enqueue_js( "
                jQuery('.rds_delivery_date_time')".$events.";
                jQuery('.add-tip-woocommerce')".$events.";
            ");
        }

	}

	$RDS_Enable_Checkout_Hook = new RDS_Enable_Checkout_Hook();
}