<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Load Filter Hooks 
 *
 * @class   RDS_Enable_My_Account_Hook
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_Enable_My_Account_Hook' ) ) {
	class RDS_Enable_My_Account_Hook {
		
        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {   
            
            add_filter( 'woocommerce_my_account_my_orders_actions', [ $this, 'RDS__add_button_my_account_order_actions' ], 10, 2 );

            add_action( 'woocommerce_order_details_after_customer_details', [ $this, 'RDS__display_order_details_with_driver_info_reviews' ], 10, 1 );
        }


        public static function RDS__add_button_my_account_order_actions( $actions, $order ) 
        {
            $shipping_admin_details   = get_option("woocommerce_roadies_settings", true);  
            if($shipping_admin_details['enabled'] == 'yes'){
                if($order->get_status() == 'completed'){
                    foreach( $order->get_items() as $item ) {
                        $actions['rating'] = array(
                            'url'  => site_url().'/my-account/view-order/' . $order->get_order_number(),
                            'name' => __( 'Rate your driver', 'my-textdomain' ),
                        );
                    }
                }
            }
            return $actions;
        }

        public static function RDS__display_order_details_with_driver_info_reviews( $order )
        {
            if(is_account_page())
            {
                $shipping_admin_details   = get_option("woocommerce_roadies_settings", true);  
                if($shipping_admin_details['enabled'] == 'yes'){
                    $delivery_date_meta       = get_post_meta( $order->id, '_roadie_billing_delivery_date', true );
                    $shipping_title           = get_post_meta( $order->id, '_roadie_shipping_title', true );
                    $shipping_tracking_number = get_post_meta( $order->id, '_roadie_shipping_tracking_number', true );
                    $tracking_id              = get_post_meta( $order->id, '_roadie_shipping_tracking_id', true );
                    $reference_id             = get_post_meta( $order->id, '_roadie_shipping_reference_id', true );
                    $tip_amount               = get_post_meta( $order->id, '_roadie_tip_amount', true );
                    $currency                 = get_woocommerce_currency_symbol( get_option( "woocommerce_currency", true ) );
                     
                    $api_details              = RDS_WC_Roadie_API_Initialization::admin_api_settings_info( 'get_shipments', $order->id );
                    $arr_ship_details         = RDS_WC_Roadie_API_Initialization::process_get_details( $api_details );
                    $arr_rd_shipping_data     = RDS_WP_DB_Query_Manager::RDS__get_orders_by_id("roadie_shipping_details", $order->id); 

                    if(!empty($arr_rd_shipping_data)){
                        require_once( RDSWC_PATH . '/includes/views/frontend/my-account-order-page/driver_review.php' ); 
                    }
                }
            }
        }

	}

	$RDS_Enable_My_Account_Hook = new RDS_Enable_My_Account_Hook();
}