<?php 

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

if ( ! class_exists( 'RDS_WC_Roadie_API_Initialization' ) ) {
    /**
     * Roadie Shipping API Initialization
     *
     * @package WooCommerce Roadie Shipment Class 
     * @author Roadie Shipment
    */
    class RDS_WC_Roadie_API_Initialization
    { 
        // Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }


        /**
         * Add this function for process of the Roadie Shipping API to Retrieve a List of Shipments
         * Method : GET
         * API Url : GET /v1/shipments?reference_ids={reference_id},{reference_id}
         * Authorization: Bearer {token}
         * Return response of Array.
         * **/
        public static function process_get_details($api_details){
            $options = [
                'method'      => 'GET',
                'headers'     => [
                    'Content-Type' => 'application/json',
                    'Authorization' => $api_details['api_request_headers'],
                ],
            ];
            $request = wp_remote_request( $api_details['api_url'], $options );  
            if ( is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) != 200 ) {
                error_log( print_r( $request, true ) );     
            }

            if(wp_remote_retrieve_response_code( $request ) == 200){           
                $response = wp_remote_retrieve_body( $request );
            } else {
                $response = wp_remote_retrieve_body( $request );
            }
            return json_decode($response, true); 
        }

        /**
         * Add this function for process of the Roadie Shipping API for create and update shipping
         * Method : POST
         * API Url : POST /v1/shipments
         * Authorization: Bearer {token}
         * Return response of Array.
         * **/
        public static function process_shipping_details($shipping_details, $api_details){
            $options = [
                'body'        => json_encode($shipping_details),
                'headers'     => [
                    'Content-Type' => 'application/json',
                    'Authorization' => $api_details['api_request_headers'],
                ],
            ];
            $request = wp_remote_post( $api_details['api_url'], $options );  
            if ( is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) != 200 ) {
                error_log( print_r( $request, true ) );     
            }

            if(wp_remote_retrieve_response_code( $request ) == 200){           
                $response = wp_remote_retrieve_body( $request );
            } else {
                $response = wp_remote_retrieve_body( $request );
            }
            return json_decode($response, true); 
        }

        /**
         * This is cancel shipping request through Roadie Shipping API.
         * Method : DELETE
         * API Url : DELETE /v1/shipments/{tracking_id}
         * Authorization: Bearer {token}
         * **/
        public static function process_cancel_details($cancel_details, $api_details){
            $options = [
                'body'        => json_encode($cancel_details),
                'method'      => 'DELETE',
                'headers'     => [
                    'Content-Type' => 'application/json',
                    'Authorization' => $api_details['api_request_headers'],
                ],
            ];
            $request = wp_remote_request( $api_details['api_url'], $options );  
            if ( is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) != 200 ) {
                error_log( print_r( $request, true ) );     
            }

            if(wp_remote_retrieve_response_code( $request ) == 200){           
                $response = wp_remote_retrieve_body( $request );
            } else {
                $response = wp_remote_retrieve_body( $request );
            }
            return json_decode($response, true); 
        }

        /**
         * Add this function for process of the Roadie Shipping API to Retrieve signature, delivery, and pickup iamge
         * Method : GET
         * API Url : GET /v1/shipments/152040/images/signature or pickup or delivery
         * Authorization: Bearer {token}
         * Return Raw Image.
         * **/
        public static function process_get_image($api_details, $image_for){
            $options = [
                'method'      => 'GET',
                'headers'     => [
                    'Content-Type' => 'application/json',
                    'Authorization' => $api_details['api_request_headers'],
                ],
            ];

            if($image_for == 'pickup'){
                $api_url = $api_details['api_url']."/images/pickup";
            } else if($image_for == 'delivery'){
                $api_url = $api_details['api_url']."/images/delivery";
            } else if($image_for == 'signature'){
                $api_url = $api_details['api_url']."/images/signature";
            }

            $request = wp_remote_request( $api_url, $options );  
            if ( is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) != 200 ) {
                error_log( print_r( $request, true ) );     
            }

            if(wp_remote_retrieve_response_code( $request ) == 200){           
                $response = wp_remote_retrieve_body( $request );
            } else {
                $response = wp_remote_retrieve_body( $request );
            }
            return $response; 
        }

        public static function admin_api_settings_info($purpose = ' ', $orderId = ' '){
            $shipping_admin_details   = get_option("woocommerce_roadies_settings", true);  
            $shipping_tracking_number = get_post_meta($orderId, '_roadie_shipping_tracking_number', true);
            $tracking_id              = get_post_meta($orderId, '_roadie_shipping_tracking_id', true);
            $reference_id             = get_post_meta($orderId, '_roadie_shipping_reference_id', true); 
            $api_details = [];
            
            if($purpose == 'estimates') {        
                $api_url = $shipping_admin_details['api_url']."estimates"; 
            } else if($purpose == 'create_shipments') {        
                $api_url = $shipping_admin_details['api_url']."shipments"; 
            } else if($purpose == 'create_tips') {        
                $api_url = $shipping_admin_details['api_url']."shipments/".$tracking_id."/tips";
            } else if($purpose == 'create_rating') {
                $api_url = $shipping_admin_details['api_url']."shipments/".$tracking_id."/ratings"; 
            } else if($purpose == 'cancel_shipment') { 
                $api_url = $shipping_admin_details['api_url']."shipments/".$tracking_id;
            } else if($purpose == 'get_image') { 
                $api_url = $shipping_admin_details['api_url']."shipments/".$tracking_id;
            } else if($purpose == 'get_shipments') {
                $api_url = $shipping_admin_details['api_url']."shipments?reference_ids=".$reference_id;           
            } else {
                $api_url = '';
            }

            return $api_details = [
                "api_url"             => $api_url,
                "api_request_headers" => $shipping_admin_details['api_request_headers']
            ];
        }
    }

    RDS_WC_Roadie_API_Initialization::get_instance();
}
