<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Helper Class Manager
 *
 * @class   RDS_WC_Helper
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_WC_Helper' ) ) {
	class RDS_WC_Helper {

		/**
	     * Check WooCommerce version
	     *
	     * @access public
	     * @param string $version
	     * @return bool
	     */
		public function wc_version_get( $version )
		{	
			if (defined('WC_VERSION') && WC_VERSION) {
				return version_compare(WC_VERSION, $version, '>=');
			}
			else if (defined('WOOCOMMERCE_VERSION') && WOOCOMMERCE_VERSION) {
				return version_compare(WOOCOMMERCE_VERSION, $version, '>=');
			} else {
				return false;
			}
		}

		public function check_product_item_description_status( $product, $arr_product )
		{	
			$status = true;
			if( empty($product->get_width()) && empty($product->get_height()) &&  empty($product->get_length()) && empty($product->get_weight()) )
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product items width, height, length and weight. Please contact to administator before checkout.' ), 'error' );
				$status = false;
			} 
			else if( empty($product->get_width()) ) 
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item width, please contact to administator before checkout.' ), 'error' );
				$status = false;
			} 
			else if( empty($product->get_height()) ) 
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item height, please contact to administator before checkout.' ), 'error' );   
				$status = false;    
			} 
			else if ( empty($product->get_length()) ) 
			{
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item length, please contact to administator before checkout.' ), 'error' );
				$status = false;
			} 
			else if( empty($product->get_weight()) ) 
			{    
				echo wc_add_notice( __( 'Missing <strong>'.esc_html($arr_product->get_title()).'</strong> product item weight, please contact to administator before checkout.' ), 'error' );
				$status = false;
			}

			if(!$status){
				remove_action( 'woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20);
			}
		}

	}

	$RDS_WC_Helper = new RDS_WC_Helper();
}