<?php 

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

if ( ! class_exists( 'RDS_WC_Order_With_Shipping_Details_Export_Class' ) ) {
    /**
     * RDS Admin Order With SHipping Details Export Class
     *
     * @package WooCommerce Roadie Shipment Class 
     * @author Roadie Shipment
    */
    class RDS_WC_Order_With_Shipping_Details_Export_Class
    { 
        // Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }

        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        private function __construct()
        {
            /**
             * Export Roadie Shipment data as CSV format.
             * **/
            //add_action('admin_menu', [$this, 'RDS__add_export_menu_item'], 99);
        }

        public static function RDS__add_export_menu_item(){
            // add_submenu_page( 'woocommerce', 'Export Roadie Orders', 'Export Roadie Orders', 'manage_options', 'export-roadie-shipping-orders', [self::$instance, 'RDS__export_roadie_shipping_order_manager'] );
        }

        public static function RDS__export_roadie_shipping_order_manager()
        {
            $shipping_admin_details   = get_option("woocommerce_roadies_settings");

            if($shipping_admin_details['enabled'] == 'yes'){
                if($_GET['page'] == 'export-roadie-shipping-orders'){
                    if((is_admin())) {
                        global $wpdb;                         
                        $orders = self::RDS__get_shipping_order_details();                         
                        $csv_data = self::RDS__set_column_head_for_csv();

                        $csv_data .= chr(13);
                        foreach( $orders as $order ){ 
                            $order_date   = RDS_WP_Global_Helper::RDS__get_date_time_format($order->post_date);
                            $order_status = ucfirst(str_replace('wc-', '', $order->post_status));
                            $orderObj     = wc_get_order($order);

                            foreach($orderObj->get_items() as $item){
                                $product_instance = wc_get_product($item['product_id']);
                                $billing_address = $orderObj->get_billing_address_1().", ".$orderObj->get_billing_city().", ".$orderObj->get_billing_state().", ".$orderObj->get_billing_postcode().", ".$orderObj->get_billing_country();
                                $shipping_address = $orderObj->get_shipping_address_1().", ".$orderObj->get_shipping_city().", ".$orderObj->get_shipping_state().", ".$orderObj->get_shipping_postcode().", ".$orderObj->get_shipping_country();
                                    /*$shipping_method = '';
                                    $shipping_cost = 0.00;
                                    foreach( $orderObj->get_items( 'shipping' ) as $ship_item ){
                                        $shipping_method = $ship_item['name'];
                                        $shipping_cost = $ship_item['total'];
                                    }*/
                               
                                /**
                                 * Get Roadie details by orderId
                                 * **/
                                $arr_rd_shipping_data = RDS_WP_DB_Query_Manager::RDS__get_orders_by_id("roadie_shipping_details", $order->ID);
                              
                                $pickup_date   = RDS_WP_Global_Helper::RDS__get_date_time_format($arr_rd_shipping_data['pickup_after']);
                                $delivery_date = RDS_WP_Global_Helper::RDS__get_date_time_format($arr_rd_shipping_data['delivery_end']);

                                $csv_data .= '"'.$order->ID.'",';      
                                $csv_data .= '"'.$orderObj->get_billing_first_name()." ".$orderObj->get_billing_last_name().'",';
                                $csv_data .= '"'.$orderObj->get_billing_email().'",';
                                $csv_data .= '"'.$orderObj->get_billing_phone().'",';
                                $csv_data .= '"'.$item['product_id'].'",';
                                $csv_data .= '"'.$item['name'].'",';
                                $csv_data .= '"'.strip_tags($product_instance->get_description()).'",';
                                $csv_data .= '"'.$orderObj->get_currency().$product_instance->get_price().'",';
                                $csv_data .= '"Roadie Shipping",';
                                $csv_data .= '"'.$orderObj->get_currency().$arr_rd_shipping_data['shipping_cost'].'",';
                                $csv_data .= '"'.$billing_address.'",';
                                $csv_data .= '"'.$shipping_address.'",';
                                $csv_data .= '"'.$arr_rd_shipping_data['tracking_id'].'",';
                                $csv_data .= '"'.$arr_rd_shipping_data['tracking_number'].'",';
                                $csv_data .= '"'.$arr_rd_shipping_data['reference_id'].'",';
                                $csv_data .= '"'.$orderObj->get_currency().$arr_rd_shipping_data['driver_tip'].'",';
                                $csv_data .= '"'.$pickup_date.'",';
                                $csv_data .= '"'.$delivery_date.'",';
                                $csv_data .= '"'.$item['quantity'].'",';            
                                $csv_data .= '"'.$orderObj->get_currency().number_format($orderObj->get_total(), 2).'",';
                                $csv_data .= '"'.$order_status.'",';  
                                $csv_data .= '"'.$order_date.'",';   
                                $csv_data .= '"'.$arr_rd_shipping_data['estimated_distance'].'",';
                                $csv_data .= '"'.ucfirst($arr_rd_shipping_data['shipping_status']).'",';
                                $csv_data .= chr(13);
                            }
                        }

                        ob_clean(); 
                        self::RDS__set_csv_header_information($csv_data);                        
                        echo $csv_data;
                        exit(); 
                    }
                }
            }
        }

        public function RDS__get_shipping_order_details()
        {
            $orders = get_posts([
                'post_type'         => 'shop_order',
                'post_status'       =>  array_keys( wc_get_order_statuses() ),
                'posts_per_page'    => -1,
            ]);

            return $orders;
        }

        public static function RDS__set_column_head_for_csv()
        {
            return 'Order Id,Customer Name,Cutomer Email,Cutomer Phone,Product Id,Product Name,Product Descriptions,Product Price,Shipping Method,Shipping Cost,Billing Address,Shipping Address,Tracking Id,Tracking Number,Reference Id,Driver Tip Amount,Pickup Date,Delivery Date,Order Quantity,Order Total,Order Status,Order Date,Estimated Distance,Shipping Status';
        }

        public static function RDS__set_csv_header_information($csv_data = '')
        {
            $get_current_date = RDS_WP_Global_Helper::RDS__get_current_date_time_format();

            header('Content-Encoding: UTF-8');
            header('Content-type: text/csv; charset=UTF-8');
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Connection: Keep-Alive');
            header('Expires: 0');      
            header('Pragma: public');
            header('Content-Disposition: attachment; filename=export_roadie_shipping_data_'.$get_current_date.'.csv');
            header('Content-Length: ' . strlen($csv_data));
        }

    }

    RDS_WC_Order_With_Shipping_Details_Export_Class::get_instance();
}
