<?php 

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

if ( ! class_exists( 'RDS_WC_Order_Details_Manager_Class' ) ) {
    /**
     * RDS Admin Order Details Manager Class
     *
     * @package WooCommerce Roadie Shipment Class 
     * @author Roadie Shipment
    */
    class RDS_WC_Order_Details_Manager_Class
    { 
        // Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }

        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {
            add_action( 'woocommerce_admin_order_data_after_order_details', [$this, 'RDS__display_shipping_details_on_admin_order_meta'], 10, 1 );
        }


        /**
         * Show Roadie Shipping informations to the admin order details section 
         * **/
        public static function RDS__display_shipping_details_on_admin_order_meta($order){  
            $shipping_title           = get_post_meta( $order->id, '_roadie_shipping_title');
            $shipping_tracking_number = get_post_meta( $order->id, '_roadie_shipping_tracking_number' );
            $tracking_id              = get_post_meta( $order->id, '_roadie_shipping_tracking_id' );
            $reference_id             = get_post_meta( $order->id, '_roadie_shipping_reference_id' );

            $shipping_admin_details   = get_option( "woocommerce_roadies_settings" );

            if($shipping_admin_details['enabled'] == 'yes'){
                require_once( RDSWC_PATH . '/includes/views/backend/rds-wc-order-meta-custom-fields.php' );
            }
        }
    }

    RDS_WC_Order_Details_Manager_Class::get_instance();
}