<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Plugin Upgrade Class 
 *
 * @class   RDS_PLGN_Upgrade_Manager
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_PLGN_Upgrade_Manager' ) ) {
	class RDS_PLGN_Upgrade_Manager { 

        // Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }

        private static $menu_slug;

        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {   
            self::$menu_slug = 'admin.php?page=roadie-shipping';

            // Load Export Class For Getting The Order and Shipping Details
            require_once( RDSWC_PATH . '/classes/rds-wc-admin-order-and-shipping-details-export-class.php' );

            add_action('admin_menu', [ $this, 'RDS__add_plugin_options_page'] );

            add_action('admin_enqueue_scripts', [ $this, 'RDS__load_wp_admin_style' ] );

            add_action('admin_init', [ $this, 'edd_sample_register_option' ] );
        }

        public static function RDS__add_plugin_options_page()
        {
            add_menu_page( 
                __( 'Plugin License', 'rds_wc_shipment_class' ),
                'Roadie Shipping',
                'manage_options',
                self::$menu_slug,
                '',
                plugins_url( 'wc-roadie-shipping-pro/includes/assets/rds-icon.png' ),
                90
            );
            add_submenu_page( 
                self::$menu_slug, 
                __( 'Settings', 'rds_wc_shipment_class' ),
                'Settings', 
                'read', 
                'admin.php?page=wc-settings&tab=shipping&section=roadies', 
                '' 
            );

            add_submenu_page( 
                self::$menu_slug, 
                __( 'Export Roadie Orders', 'rds_wc_shipment_class' ),
                'Export Roadie Orders', 
                'read', 
                'export-roadie-shipping-orders', 
                [self::$instance, 'RDS__export_roadie_order_data'] 
            );

            add_submenu_page(
                self::$menu_slug,               
                'Plugin License',                      
                'Plugin License',                      
                'manage_options',                   
                'roadie-shipping-license',               
                [self::$instance, 'RDS__activate_plugin_license'] 
            );

            // Delete plugin primary menu item name.
            global $submenu;
            unset( $submenu['admin.php?page=roadie-shipping'][0] ); 
        }

        public function RDS__load_wp_admin_style(){
            wp_enqueue_style( 'admin-style', RDSWC_URL . "/includes/assets/css/admin-style.css", false, '1.0.0', 'all' ); 
        }

        public function RDS__activate_plugin_license()
        {   
             //$status = 0;  
            /*echo "<pre>"; print_r($_POST); //exit;   
            if( !empty($_POST['rds_license_key']) && !empty($_POST['rds_access_token']) ){
                $_POST = [
                    'license_key'  => $_POST['rds_license_key'],
                    'access_token' => $_POST['rds_access_token']
                ];
                print_r($_POST);
                $exist_option = get_option("activation_data");
                if(empty($exist_option)){
                    update_option('activation_data', $_POST);
                    $status = 1;
                } 
            }  */
            require_once( RDSWC_PATH . '/includes/views/backend/rds-plugin-validation.php' );
        }

        public function edd_sample_register_option()
        {   
            if( isset( $_POST['rds_license_activate'] ) ) {            
               if ( empty( $_POST['rds_license']['key'] ) && empty( $_POST['rds_license']['access_token'] ) ){ 
                    echo '<div class="notice notice-error is-dismissible"> <p>License key & access token are required.</p> </div>'; 
                    return;
                } else if(empty( $_POST['rds_license']['key'] )) {
                    echo '<div class="notice notice-error is-dismissible"> <p>License key is required.</p> </div>';
                    return;
                } else if(empty( $_POST['rds_license']['access_token'] )) {
                    echo '<div class="notice notice-error is-dismissible"> <p>Access token is required.</p> </div>';
                    return;
                } else{               
                    register_setting('rds', 'rds_license', [$this, 'license_key_callback']);
                }
            }
           
        }
        public function license_key_callback($options) {
            update_option( 'activation_data', $options );
            // echo "Sss"; print_r($options['access_token']); exit;
        }   


        public function RDS__export_roadie_order_data()
        {
            RDS_WC_Order_With_Shipping_Details_Export_Class::RDS__export_roadie_shipping_order_manager();
        }
    }

    RDS_PLGN_Upgrade_Manager::get_instance();
}
