jQuery(document).ready(function(){

    jQuery(document.body).on('change', 'input[name^="shipping_method"]', function() {
        if ( 'roadies' !== jQuery(this).val() ) {
            jQuery('.rds_delivery_date_time').slideUp(); // hide delivery date & time
            jQuery('.add-tip-woocommerce').slideUp(); // hide tip section
        } else {
            jQuery('.rds_delivery_date_time').slideDown(); // show delivery date & time
            jQuery('.add-tip-woocommerce').slideDown(); // show tip section           
        }
    });

    /**
     * Tip section toggle
     * */
    jQuery("#tip-heading").click(function(){
        jQuery(".tip-wrapper").slideToggle(450);    
    });  

    jQuery('#stars li').on('mouseover', function(){
        var onStar = parseInt(jQuery(this).data('value'), 10);
        jQuery(this).parent().children('li.star').each(function(e){
            if (e < onStar) {
                jQuery(this).addClass('hover');
            }
            else {
                jQuery(this).removeClass('hover');
            }
        });    
    }).on('mouseout', function(){
        jQuery(this).parent().children('li.star').each(function(e){
          jQuery(this).removeClass('hover');
      });
    });

    jQuery('#stars li').on('click', function(){
        var onStar = parseInt(jQuery(this).data('value'), 10); 
        var stars = jQuery(this).parent().children('li.star');    
        for (i = 0; i < stars.length; i++) {
          jQuery(stars[i]).removeClass('selected');
      }    
      for (i = 0; i < onStar; i++) {
          jQuery(stars[i]).addClass('selected');
      }

      var rat_value = parseInt(jQuery('#stars li.selected').last().data('value'), 10);
      var rat_text = jQuery('#stars li.selected small').last().text();
      var rating_value = rat_value;
      jQuery('.driver_rating').val(rating_value);                                       
  });  

    jQuery('.submit_review').on('click', function() { 
        if(jQuery('.driver_rating').val() == ''){
            jQuery('.error_rating_number').text('Please enter rating');
            return false;
        } else {
            jQuery('.error_rating_number').text('');
        }
        if(jQuery('.driver_review_text').val() == ''){
            jQuery('.error_text').text('Please enter comments');
            return false;
        } else {  
            jQuery('.error_text').text('');
        }
        if(jQuery('.driver_review_text').val() != '' && jQuery('.driver_rating').val() != ''){ 
            jQuery('.review-loader').removeClass('hidden');
            jQuery('.submit_review').prop('disabled', true);

            jQuery.ajax({
                url: RDS__ajaxurl,
                method: 'POST',
                cache: 'false',
                dataType: 'json',
                data: {
                    'action': 'submit_review_text',
                    'rating_number': jQuery('.driver_rating').val(),
                    'review_text': jQuery('.driver_review_text').val(),
                    'driver_name': jQuery('.driver_name').val(),
                    'driver_phone': jQuery('.driver_phone').val(),
                    'order_id': jQuery('.order_id').val(),
                },
                success: function (response) {
                    if(response.status === true){
                        jQuery('.response_msg').text(response.msg);
                        jQuery('.response_msg').addClass('text-success');
                    } else {                                                
                        jQuery('.response_msg').text(response.msg);
                        jQuery('.response_msg').addClass('text-danger');
                    }

                    jQuery('.review-loader').addClass('hidden');   
                    jQuery('.submit_review').prop('disabled', false);

                    setTimeout(function() { 
                        jQuery('.response_msg').text('').removeClass('text-success').removeClass('text-danger');
                    }, 8000);
                },
                error: function (errorThrown) {                                           
                }
            });
        }
    });

});