<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Cart Page Hook 
 *
 * @class   RDS_Enable_Cart_Hook
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_Enable_Cart_Hook' ) ) {
	class RDS_Enable_Cart_Hook {
		
        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {
			
            add_filter( 'woocommerce_cart_shipping_method_full_label', [ $this, 'RDS__shipping_hide_method_title' ] );

            add_filter( 'woocommerce_no_shipping_available_html', [ $this, 'RDS__customize_default_message' ], 10, 1 );
            add_filter( 'woocommerce_cart_no_shipping_available_html', [ $this, 'RDS__customize_default_message' ], 10, 1 );


            add_action( 'woocommerce_before_cart', [ $this, 'RDS__check_product_details_before_added_to_cart' ], 10, 1 );
 
            add_action( 'woocommerce_checkout_process', [ $this, 'RDS__check_product_details_before_checkout' ], 10 );
        }


        public static function RDS__shipping_hide_method_title( $label ) 
        {
            $label = str_replace(':', '', $label);
            return $label;
        }

        public static function RDS__customize_default_message($sprintf) 
        {
            $packages         = WC()->shipping()->get_packages();
            $shipping_err_msg = get_option('shipping_error_msg');

            foreach ( $packages as $i => $package ) {
                $formatted_destination = WC()->countries->get_formatted_address( $package['destination'], ', ' );
            }
            if(!empty($shipping_err_msg)){
                $sprintf = sprintf( esc_html__( 'Unfortunately, we don\'t ship to %s. Please contact our Support if you need any help.', 'woocommerce' ) . ' ', '<strong>' . esc_html( $formatted_destination ) . '</strong>' );
            }
            return $sprintf;
        }

        
        public static function RDS__check_product_details_before_added_to_cart( $product ) 
        {
            if(is_cart()){
                if(WC()->session->get('chosen_shipping_methods')[0] == 'roadies'){
                    $arr_product = [];
                    foreach ( WC()->cart->get_cart() as $cart_item ) {
                        $arr_product_data = $cart_item['data'];
                    }
                    $objProduct = wc_get_product( $arr_product_data->get_id() );

                    if( $arr_product_data->is_type( 'simple' ) ){
                        RDS_WC_Helper::check_product_item_description_status( $objProduct, $arr_product_data );
                    }
                }
            }
        }

        public static function RDS__check_product_details_before_checkout()
        {
            if(is_checkout()){
                if(WC()->session->get('chosen_shipping_methods')[0] == 'roadies'){
                    $arr_product = [];
                    foreach ( WC()->cart->get_cart() as $cart_item ) {
                        $arr_product_data = $cart_item['data'];
                    }
                    $objProduct = wc_get_product( $arr_product_data->get_id() );

                    if( $arr_product_data->is_type( 'simple' ) ){
                        RDS_WC_Helper::check_product_item_description_status( $objProduct, $arr_product_data );
                    }
                }
            }
        }

	}

	$RDS_Enable_Cart_Hook = new RDS_Enable_Cart_Hook();
}