<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Roadie Shipping Load Filter Hooks 
 *
 * @class   RDS_Enable_My_Account_Hook
 * @package Roadie Shipping
 * @author 	Roadie Shipping
 */
if ( ! class_exists( 'RDS_Enable_My_Account_Hook' ) ) {
	class RDS_Enable_My_Account_Hook {
		
        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {   
            
            add_filter( 'woocommerce_my_account_my_orders_actions', [ $this, 'RDS__add_button_my_account_order_actions' ], 10, 2 );

            add_action( 'woocommerce_order_details_after_customer_details', [ $this, 'RDS__display_order_details_with_driver_info_reviews' ], 10, 1 );

            add_action( 'wp_ajax_nopriv_submit_review_text', [ $this, 'RDS__submit_review_text_callback' ] );
            add_action( 'wp_ajax_submit_review_text', [ $this, 'RDS__submit_review_text_callback' ] );

        }


        public static function RDS__add_button_my_account_order_actions( $actions, $order ) 
        {
            $shipping_admin_details   = get_option("woocommerce_roadies_settings", true);  
            if($shipping_admin_details['enabled'] == 'yes'){
                if($order->get_status() == 'completed'){
                    foreach( $order->get_items() as $item ) {
                        $actions['rating'] = array(
                            'url'  => site_url().'/my-account/view-order/' . $order->get_order_number(),
                            'name' => __( 'Rate your driver', 'my-textdomain' ),
                        );
                    }
                }
            }
            return $actions;
        }

        public static function RDS__display_order_details_with_driver_info_reviews( $order )
        {
            if(is_account_page())
            {
                $shipping_admin_details   = get_option("woocommerce_roadies_settings", true);  
                if($shipping_admin_details['enabled'] == 'yes'){
                    $delivery_date_meta       = get_post_meta( $order->id, '_roadie_billing_delivery_date', true );
                    $shipping_title           = get_post_meta( $order->id, '_roadie_shipping_title', true );
                    $shipping_tracking_number = get_post_meta( $order->id, '_roadie_shipping_tracking_number', true );
                    $tracking_id              = get_post_meta( $order->id, '_roadie_shipping_tracking_id', true );
                    $reference_id             = get_post_meta( $order->id, '_roadie_shipping_reference_id', true );
                    $tip_amount               = get_post_meta( $order->id, '_roadie_tip_amount', true );
                    $currency                 = get_woocommerce_currency_symbol( get_option( "woocommerce_currency", true ) );
                     
                    $api_details              = RDS_WC_Roadie_API_Initialization::admin_api_settings_info( 'get_shipments', $order->id );
                    $arr_ship_details         = RDS_WC_Roadie_API_Initialization::process_get_details( $api_details );
                    $arr_rd_shipping_data     = RDS_WP_DB_Query_Manager::RDS__get_orders_by_id("roadie_shipping_details", $order->id); 

                    if(!empty($arr_rd_shipping_data)){
                        require_once( RDSWC_PATH . '/includes/views/frontend/my-account-order-page/driver_review.php' ); 
                    }
                }
            }
        }

        public function RDS__submit_review_text_callback()
        {
            global $wpdb;
            $driver_table = $wpdb->prefix."roadie_drivers";
            $review_table = $wpdb->prefix."driver_review";
            $res = [];

            if(!empty($_POST['driver_name']) && !empty($_POST['order_id'])){
                $arr_driver_info = RDS_WP_DB_Query_Manager::RDS__get_driver_info_by_name( "roadie_drivers", trim($_POST['driver_name']) );
                if(empty($arr_driver_info)){
                    $total_order_count = 1;
                    if(!empty($arr_driver_info['total_orders'])){
                        $total_order_count = $arr_driver_info['total_orders'] + 1;
                    }
                    $total_rating_count = 1;
                    if(!empty($arr_driver_info['total_ratings'])){
                        $total_rating_count = $arr_driver_info['total_ratings'] + 1;
                    }

                    $dr_insert_data = [
                        'name'          => $_POST['driver_name'], 
                        'phone'         => $_POST['driver_phone'],
                        'total_orders'  => $total_order_count, 
                        'total_ratings' => $total_rating_count,
                        'created_on'    => date("Y-m-d h:i:s")     
                    ];
                    $driver_id = $wpdb->insert($driver_table, $dr_insert_data);
                } else {
                    $sql = "UPDATE $driver_table SET `name` = '".$_POST['driver_name']."', `phone` = '".$_POST['driver_phone']."', `total_orders` = '".$arr_driver_info['total_orders']."', `total_ratings` = '".$arr_driver_info['total_ratings']."', `modified_on` = '". date('Y-m-d h:i:s') ."' WHERE `id` = ".$arr_driver_info['id']."";                  
                    $wpdb->query($wpdb->prepare($sql)); 
                    $driver_id = $arr_driver_info['id'];
                }

                if(!empty($driver_id)){ 
                    /**
                     * Review Table Update
                     * **/    
                    $arr_review_info = $wpdb->get_row("SELECT * FROM ".$review_table." WHERE order_id='".$_POST['order_id']."' AND driver_id='".$driver_id."'", ARRAY_A);

                    if(empty($arr_review_info)){
                        $rw_insert_data = [
                            'order_id'  => $_POST['order_id'], 
                            'driver_id' => $driver_id,
                            'rating'    => !empty($_POST['rating_number'])?$_POST['rating_number']:1, 
                            'comments'  => sanitize_text_field($_POST['review_text']),
                            'created_on'=> date("Y-m-d h:i:s")      
                        ];
                        $review_id = $wpdb->insert($review_table, $rw_insert_data);

                        /**
                         * Update Total Order and Total Rating for individual driver after review insert.
                         * **/
                        $total_order_count = 1;
                        if(!empty($arr_driver_info['total_orders'])){
                            $total_order_count = $arr_driver_info['total_orders'] + 1;
                        }
                        $total_rating_count = 1;
                        if(!empty($arr_driver_info['total_ratings'])){
                            $total_rating_count = $arr_driver_info['total_ratings'] + 1;
                        }
                        $sql2 = "UPDATE $driver_table SET `name` = '".$_POST['driver_name']."', `phone` = '".$_POST['driver_phone']."', `total_orders` = '".$total_order_count."', `total_ratings` = '".$total_rating_count."', `modified_on` = '". date('Y-m-d h:i:s') ."' WHERE `id` = ".$arr_driver_info['id']."";              
                        $wpdb->query($wpdb->prepare($sql2));
                    } else {
                        /*$sql1 = "UPDATE $review_table SET `order_id` = '".$_POST['order_id']."', `driver_id` = '".$driver_id."', `rating` = '".$_POST['rating_number']."', `comments` = '".sanitize_text_field($_POST['review_text'])."', `updated_on` = '". date('Y-m-d h:i:s') ."' WHERE `id` = ".$arr_review_info['id']."";  
                                     
                        $wpdb->query($wpdb->prepare($sql1)); */
                        $review_id = $arr_review_info['id'];
                    } 

                    /**
                     * Leave a Rating for the Driver
                     * */
                    if(!empty($review_id)){    
                        $rd_rating_details  =  [ "value" => (int)$_POST['rating_number'] ];
                        $api_details        = RDS_WC_Roadie_API_Initialization::admin_api_settings_info('create_rating', $_POST['order_id']);
                        $rd_review_response = RDS_WC_Roadie_API_Initialization::process_shipping_details($rd_rating_details, $api_details);  

                        if(!empty($rd_review_response['errors'][0]['message'])){
                            $res = ["status" => 'false', "msg" => $rd_review_response['errors'][0]['message'] ];
                        } else {
                            $res = ["status" => 'true', "msg" => "Your are awesome! Thanks for the review."];
                            update_post_meta($_POST['order_id'], '_roadie_rating_number', $_POST['rating_number']);
                        }
                    }
                } else {
                    $res = ["status" => 'false', "msg" => "Your review has not been submitted, please try again."];
                }
            } else {
                $res = ["status" => 'false', "msg" => "Required driver name and order id to submit the review."];
            }
            die(json_encode($res));
        }

	}

	$RDS_Enable_My_Account_Hook = new RDS_Enable_My_Account_Hook();
}