<?php 
/**
 * Plugin Name: Roadie Shipment for Woocommerce Basic
 * Plugin URI: https://docs.roadie.com/#api-overview
 * Description: This plugin can calculate the shipping cost depending upon the product item, delivery location, pickup location and delivery timestamp. Also delivery date & time can be changed manually. You can get the driver details and anyone can give rating and review the driver and also show the all reviews. 
 * Author: Pipopie LLC
 * Version: 1.0.0
 * Tested up to: 6.0.1
 * License: GNU General Public License v3.0
 */

/**
* @package Roadie Shipment for Woocommerce
* @author  Pipopie LLC
* @license GPL-3.0+
* @link    http://www.gnu.org/licenses/gpl-3.0.html
**/


// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}


define( 'RDSWC_SUPPORT_WC', '3.0' );
define( 'RDSWC_URL', plugin_dir_url( __FILE__ ) );
define( 'RDSWC_PATH', plugin_dir_path( __FILE__ ) );
define( 'RDSWC_BASENAME', plugin_basename( __FILE__ ) );
define( 'RDSWC_PLUGINNAME', 'Roadie Shipment for Woocommerce Plugin' ); 
define( 'RDSWC_APIURL', 'https://yofidelivery.com/wp-json/rds-shipment/v1' );


// Make sure WooCommerce is active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
	return;
} 

if ( ! class_exists( 'RDS_WC_Shipment_Class' ) ) {
   /**
    * Main plugin class
    *
    * @package WooCommerce Roadie Shipment Class 
    * @author Roadie Shipment
    */
   class RDS_WC_Shipment_Class
   {  
      /**
        * Class constructor
        *
        * @access public
        * @return void
        */
      public function __construct()
      {
         register_activation_hook( __FILE__, [$this, 'WPRDS_table_creation'] );

         register_deactivation_hook( __FILE__, [ $this, 'RDS_plugin_data_restoration' ] );

         // Execute other code when all plugins are loaded
         add_action('plugins_loaded', [$this, 'RDS_on_plugins_loaded'], 1);
      }
      
      /**
        * Creating a custom database table on plugin activation.
        *
        * @access public
        * @return void
        */
      public function WPRDS_table_creation(){ 
         //Check this sql file if the tables are already exists, if not, then create it from the sql file.
         require_once( RDSWC_PATH . '/includes/rds_sql.php' );  

         $this->store_plugin_details();

      }

      /**
        * Code executed when all plugins are loaded
        *
        * @access public
        * @return void
        */
      public function RDS_on_plugins_loaded() {

         // Load all the Class, Hooks files.
         require_once( RDSWC_PATH . '/extensions/rds-load-class.php' );

         // Check environment
         if (RDS_WC_Shipment_Class::RDS_check_environment()) {
            return;
         }      

      }

      /**
        * Check if environment meets requirements
        *
        * @access public
        * @return bool
        */
      public function RDS_check_environment()
      {  
         // Check if WooCommerce is enabled
         if ( !RDS_WC_Helper::wc_version_get(RDSWC_SUPPORT_WC) ) {
            add_action('admin_notices', array('RDS_WC_Shipment_Class', 'wc_version_notice'));
            return false;
         }     
      }

      /**
        * Display WC version notice
        *
        * @access public
        * @return void
        */
      public function wc_version_notice()
      {

         echo '<div class="error"><p>' . sprintf(esc_html__('%1$s requires WooCommerce version %2$s or later. Please update WooCommerce to use this plugin.', 'rds_wc_shipment_class'), '<strong>'. RDSWC_PLUGINNAME .'</strong>', '<strong>'. RDSWC_SUPPORT_WC .'</strong>' ) . ' ' . sprintf(esc_html__('If you have any questions, please contact %s.', 'rds_wc_shipment_class'), ('<a href="http://pieopie.com/contact-us/">' . esc_html__('Pieopie Support', 'rds_wc_shipment_class') . '</a>')) . '</p></div>';
      }

      public function store_plugin_details ()
      {  
         $date        = new DateTime();
         $plugin_name = explode("/", RDSWC_BASENAME);
         $urlparts    = parse_url(home_url());
         
         $postData    = [
            "plugin_name"       => ucwords(str_replace("-", " ", $plugin_name[0])),
            "activation_key"    => "",
            "activation_token"  => "",
            "ip_address"        => getHostByName(getHostName()), //$_SERVER['REMOTE_ADDR'], 
            "system_name"       => php_uname('s'),
            "site_name"         => $urlparts['host'],
            "created_on"        => $date->format('Y-m-d H:i:s'),
         ]; 
         
         update_option('rds_license', []);
         $api_url    = RDSWC_APIURL.'/store/plugin_info';
         $apiOptions = [
               'body'        => json_encode($postData),
               'headers'     => [
                  'Content-Type' => 'application/json',
                  // 'Authorization' => $api_details['api_request_headers'],
               ],
         ];
         $request = wp_remote_post( $api_url , $apiOptions ); 
         if(wp_remote_retrieve_response_code( $request ) == 200){           
            $response = wp_remote_retrieve_body( $request );
         }
      }

      public function RDS_plugin_data_restoration () {
         $date        = new DateTime();
         $plugin_name = explode("/", RDSWC_BASENAME);
         $urlparts    = parse_url(home_url());
         
         $postData    = [
            "plugin_name"       => ucwords(str_replace("-", " ", $plugin_name[0])),
            "activation_key"    => "",
            "activation_token"  => "",
            "ip_address"        => getHostByName(getHostName()), //$_SERVER['REMOTE_ADDR'], 
            "system_name"       => php_uname('s'),
            "site_name"         => $urlparts['host'],
            "status"            => 0,
            "modified_on"       => $date->format('Y-m-d H:i:s'),
         ]; 

         update_option('rds_license', []);
         $api_url    = RDSWC_APIURL.'/update/plugin_info';
         $apiOptions = [
               'body'        => json_encode($postData),
               'headers'     => [
                  'Content-Type' => 'application/json',
               ],
         ];
         $request = wp_remote_post( $api_url , $apiOptions ); 
         if(wp_remote_retrieve_response_code( $request ) == 200){           
            $response = wp_remote_retrieve_body( $request );
         }
      }

}

   // Load object of RDS_WC_Shipment_Class.
   $RDS_WC_Shipment_Class = new RDS_WC_Shipment_Class();
}