<?php
// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Roadie Shipping Method Settings
 *
 * @class   WC_Custom_Shipping_Method_Settings
 * @extends WC_Shipping_Method
 */
function roadie_shipping_method() {
    if ( ! class_exists( 'WC_Custom_Shipping_Method_Settings' ) ) {
        class WC_Custom_Shipping_Method_Settings extends WC_Shipping_Method
        {   
            /**
             * Constructor for your shipping class
             *
             * @access public
             * @return void
            */
            public function __construct() {
                $this->id                    = 'roadies'; 
                $this->method_title          = __( 'Roadie Shipping', 'roadies' );  
                $this->method_description    = __( 'Custom Shipping Method for Roadie. <div class="error notice" style="padding: 20px; font-size: 16px; font-weight: 600;">It is required to fill up the store details, proceed to WooCommerce Genaral Tab by <a href="'.admin_url().'admin.php?page=wc-settings&tab=general">click here</a>.</div>', 'roadies' );

                $this->init();
                $this->enabled                = isset( $this->settings['enabled'] ) ? $this->settings['enabled'] : 'yes';
                $this->title                  = isset( $this->settings['title'] ) ? $this->settings['title'] : __( 'Roadie Shipping', 'roadies' );

                $this->api_mode               = isset( $this->settings['api_mode'] ) ? $this->settings['api_mode'] : __( ' ', 'roadies' );              
                $this->api_url                = isset( $this->settings['api_url'] ) ? $this->settings['api_url'] : __( ' ', 'roadies' );
                $this->api_request_headers    = isset( $this->settings['api_request_headers'] ) ? $this->settings['api_request_headers'] : __( ' ', 'roadies' );

                add_action( 'woocommerce_settings_general', [$this, 'action_woocommerce_settings_general'], 10 );
            }

            /**
             * Init your settings
             *
             * @access public
             * @return void
             */
            public function init() {

                $this->mode_options = [
                    'sandbox' => __( 'Sandbox', 'roadies' ),
                    'live'    => __( 'Live', 'roadies' ),
                ]; 
                
                $this->init_form_fields(); 
                $this->init_settings(); 
                // Save settings in admin if you have any defined

                add_action( 'woocommerce_settings_general', [$this, 'action_woocommerce_settings_general'], 10 );
                
                add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
            }
            /**
             * Define settings field for this shipping
             * @return void 
             */
            public function init_form_fields() { 

                $this->form_fields = array( 
                    'enabled' => array(
                        'title'       => __( 'Enable', 'RDSWC' ),
                        'type'        => 'checkbox',
                        'description' => __( 'Enable this shipping.', 'RDSWC' ),
                        'default'     => 'yes'
                    ),         
                    'title' => array(
                        'title'       => __( 'Title', 'RDSWC' ),
                        'type'        => 'text',
                        'description' => __( 'Title to be display on site', 'RDSWC' ),
                        'default'     => __( 'Roadie Shipping', 'RDSWC' )
                    ),                    
                    'api_mode' => array(
                        'title'       => __( 'Mode', 'RDSWC' ),
                        'type'        => 'select',
                        'description' => __( '', 'RDSWC' ),
                        'default'     => __( 'sandbox', 'RDSWC' ),                        
                        'options'     => $this->mode_options,
                    ),               
                    'api_url' => array(
                        'title'       => __( 'Roadie API URL ', 'RDSWC' ),
                        'type'        => 'text',
                        'description' => __( 'The gateway will send the shipping data to this URL after checkout. Get the <strong>Roadie API Url</strong> from this <a href="https://my-sandbox.roadie.com/send/account/settings" target="_blank">link</a>.', 'RDSWC' ),
                        'default'     => __( ' ', 'RDSWC' )
                    ), 
                    'api_request_headers' => array(
                        'title'       => __( 'Roadie Access Token', 'RDSWC' ),
                        'type'        => 'text',
                        'description' => __( 'Get the <strong>Header Information</strong> from this <a href="https://my-sandbox.roadie.com/send/account/settings" target="_blank">link</a>. <em>(Example: Bearer 5f6asd654sfs4f8f582qwr58tm4b58r5r)</em>.', 'RDSWC' ),
                        'default'     => __( ' ', 'RDSWC' )
                    ),         
                );
            }

            /**
             * This function is used to calculate the shipping cost. Within this function we can check for weights, dimensions and other parameters.
             *
             * @access public
             * @param mixed $package
             * @return void
             */
            public function calculate_shipping( $package = [] ) {
                $shipping_data = [];
                $item = [];
                $cost = 0.0;
                /**
                 * Store address / Pickup Address [This is where your business is located]
                 * Woocommerce
                 * **/ 
                $store_address        = !empty(WC()->countries->get_base_address()) ? WC()->countries->get_base_address() : " ";
                $store_address_2      = !empty(WC()->countries->get_base_address_2()) ? WC()->countries->get_base_address_2() : null;
                $store_city           = !empty(WC()->countries->get_base_city()) ? WC()->countries->get_base_city() : " ";
                $store_postcode       = !empty(WC()->countries->get_base_postcode()) ? WC()->countries->get_base_postcode() : " ";
                $store_state          = !empty(WC()->countries->get_base_state()) ? WC()->countries->get_base_state() : " ";
                $store_country        = !empty(WC()->countries->get_base_country()) ? WC()->countries->get_base_country() : " ";
                /**
                 * Shipping address 
                 * Woocommerce
                 * **/ 
                $shipping_address     = !empty($package["destination"]['address']) ? $package["destination"]['address'] : "456 Central Ave.";
                $shipping_address_1   = !empty($package["destination"]['address1']) ? $package["destination"]['address1'] : null;
                $shipping_city        = !empty($package["destination"]['city']) ? $package["destination"]['city'] : "Atlanta";
                $shipping_postcode    = !empty($package["destination"]['postcode']) ? $package["destination"]['postcode'] : "30308";
                $shipping_state       = !empty($package["destination"]['state']) ? $package["destination"]['state'] : "GA";
                $shipping_country     = !empty($package["destination"]['country']) ? $package["destination"]['country'] : "US";

                $pickup_after_time    = date('Y-m-d\TH:i:s\Z');
                $deliver_start_time   = date('Y-m-d\TH:i:s\Z', strtotime(' +8 hours'));
                $deliver_end_time     = date('Y-m-d\TH:i:s\Z', strtotime(' +4 hours', strtotime($deliver_start_time)));
                foreach ( $package['contents'] as $item_id => $values ) {  
                    $product_id = $values['product_id'];
                    $_product   = $values['data'];  
                    $quantity   = $values['quantity'];
                    $weight     = (float)$_product->get_weight() * $quantity;
                    $length     = (float)$_product->get_length();
                    $width      = (float)$_product->get_width();
                    $height     = (float)$_product->get_height();

                    array_push($item, [
                        "quantity"  => !empty($quantity) ? $quantity : 1,
                        "weight"    => !empty($weight) ? $weight : 1.0, 
                        "length"    => !empty($length) ? $length : 1.0, 
                        "width"     => !empty($width) ? $width : 1.0,
                        "height"    => !empty($height) ? $height : 1.0
                    ]);
                }

                $shipping_data = [
                    "items" => $item,
                    "pickup_location" => [
                        "address" => [    
                            "street1" => $store_address,    
                            "street2" => $store_address_2,    
                            "city"    => $store_city,    
                            "state"   => $store_state,    
                            "zip"     => $store_postcode]
                        ],
                        "delivery_location" => [
                            "address" => [    
                            "street1" => $shipping_address,    
                            "street2" => $shipping_address_1,    
                            "city"    => $shipping_city,    
                            "state"   => $shipping_state,    
                            "zip"     => $shipping_postcode]
                        ],
                        "pickup_after"    => $pickup_after_time,
                        "deliver_between" => [
                            "start"       => $deliver_start_time,
                            "end"         => $deliver_end_time
                        ],
                    ];
                    $shipping_details = $this->send_shipping_details($shipping_data);
                   
                    if(!empty($shipping_details)){
                        $cost = @$shipping_details['price']; 
                        $rate = array('id'    => $this->id,'label' => $this->title,'cost'  => $cost );
                        $this->add_rate( $rate );      
                        update_option("roadie_api_error_msg", "");                
                    } 
            }

            /**
             * Call API functions
             *
             * @access public
             * @param Array $data
             * @return Json data
             */
            public function send_shipping_details( $data ) {
                $api_details = RDS_WC_Roadie_API_Initialization::admin_api_settings_info('estimates', ' '); 
                return RDS_WC_Roadie_API_Initialization::process_shipping_details($data, $api_details);
            }
            

            public function action_woocommerce_settings_general() {
                global $current_tab;    
                $store_contact_name   = get_option("woocommerce_store_fullname");
                $store_contact_number = get_option("woocommerce_store_phone");
                if(empty($store_contact_name)){ 
                    add_settings_error('title_long_error', '', __('Please enter the full name.'), 'error');
                }
                if(empty($store_contact_number)){
                    add_settings_error('title_long_error', '', __('Please enter the phone number.'), 'error');
                }
                settings_errors( 'title_long_error' );
            }
        } 
    }
}
add_action( 'woocommerce_shipping_init', 'roadie_shipping_method' );

add_action( 'admin_head', function() {
    $rds = RDS_WP_Global_Helper::RDS__get_license_details();
    echo RDS_WC_Helper::RDS__get_notice_error_message($rds);
});


add_filter( 'woocommerce_no_shipping_available_html', 'rds_api_error_for_no_shipping_method_set' );
add_filter( 'woocommerce_cart_no_shipping_available_html', 'rds_api_error_for_no_shipping_method_set' );
function rds_api_error_for_no_shipping_method_set( $message ) {
    $api_error_msg = "";
    if(is_cart() || is_checkout()){
        $api_error_msg = '<span class="shipping_err">'.get_option("roadie_api_error_msg", true).'</span>';
    } else {
        update_option("roadie_api_error_msg", "");   
        $api_error_msg = "";
    }
    return __( $api_error_msg);
}  


add_filter( 'woocommerce_general_settings', 'general_settings_shop_phone' );            
function general_settings_shop_phone($settings) {
    $key = 0;
    foreach( $settings as $values ){
        $new_settings[$key] = $values;
        $key++;
        // Inserting array just after the post code in "Store Address" section
        if($values['id'] == 'woocommerce_store_postcode'){
            $new_settings[$key] = array(
                'title'    => __('Full Name'),
                'desc'     => __('Full name of your business office'),
                'id'       => 'woocommerce_store_fullname', 
                'default'  => '',
                'type'     => 'text',
                'desc_tip' => true, 
            );
            $key++;
        }

        if($values['id'] == 'woocommerce_store_postcode'){
            $new_settings[$key] = array(
                'title'    => __('Phone Number'),
                'desc'     => __('Phone number of your business office'),
                'id'       => 'woocommerce_store_phone', 
                'default'  => '',
                'type'     => 'text',
                'desc_tip' => true, 
            );
            $key++;
        }
    }
    return $new_settings;
}

add_action( 'woocommerce_settings_save_shipping', 'action_woocommerce_settings_save_roadies', 10 );
function action_woocommerce_settings_save_roadies() {
    global $current_section; 
    if($current_section == 'roadies'){  
        $store_contact_name   = get_option("woocommerce_store_fullname");
        $store_contact_number = get_option("woocommerce_store_phone");
        if(empty($store_contact_name) || empty($store_contact_number)){
            echo wp_redirect( admin_url().'admin.php?page=wc-settings&tab=general' ); 
        }
    }
} 
?>