<?php 
// Exit if accessed directly
defined('ABSPATH') || exit;



/**
 * Roadie Shipping WC Hooks
 *
 * @class   RDS_WC_Hook
 * @package Roadie Shipping
 * @author  Roadie Shipping
 */
if ( ! class_exists( 'RDS_WC_Hook' ) ) {
    class RDS_WC_Hook {

        // Singleton control
        protected static $instance = false; 
        public static function get_instance() { 
            return self::$instance ? self::$instance : (self::$instance = new self());
        }

        /**
         * Constructor
         *
         * @access public
         * @return void
         */
        public function __construct()
        {               

            // Load Cart Page Hooks
            require_once( RDSWC_PATH . '/includes/wp-hooks/cart/rds-enable-cart-hooks.php' ); 

            // Load Checkout Page Hooks
            require_once( RDSWC_PATH . '/includes/wp-hooks/checkout/rds-enable-checkout-hooks.php' );   


            add_action( 'wp_footer', [ $this, 'RDS__add_wc_page_script' ], 20 );  

            
            add_filter( 'woocommerce_shipping_methods', [$this, 'RDS__add_roadie_shipping_method'] );
            
            // Custom address field customizations
            add_filter( 'woocommerce_shipping_calculator_enable_address', [ $this, '__return_true' ] );


            add_action( 'wp_enqueue_scripts', [ $this, 'RDS__add_plugin_style' ], 10 );


            add_action( 'woocommerce_checkout_update_order_meta', [ $this, 'RDS__update_order_shipping_data_by_create_shipping' ], 10, 2 );

            add_action( 'woocommerce_thankyou', [ $this, 'RDS__shipping_view_result' ], 10, 1 );


            add_action( 'init', [ $this, 'RDS__cancel_wc_order' ], 10 );        

        }


        public function RDS__add_roadie_shipping_method( $methods ) 
        {
            $methods['roadie_shipping'] = 'WC_Custom_Shipping_Method_Settings';
            return $methods;
        }

     
        public function RDS__add_plugin_style() 
        { 
            $active_plugins = apply_filters( 'active_plugins', get_option( 'active_plugins' ) );
            $folder_name    = RDS_WC_Helper::RDS__find_plugin_folder_name(RDSWC_URL);

            if ( in_array( $folder_name.'/class-roadie-shipment-for-woocommerce.php', $active_plugins ) ) {
                if(is_checkout()){
                    wp_enqueue_style( 'jquery-datetimepicker-ui', RDSWC_URL . "/includes/assets/css/external/jquery.datetimepicker.min.css", false, '2.5.4', 'all' ); 
                    wp_enqueue_script( 'jquery-ui-datepicker' );
                    wp_enqueue_script( 'jquery-ui-script',  RDSWC_URL . "/includes/assets/js/external/jquery-ui.min.js", array(), '1.11.4', true );
                    wp_enqueue_script( 'jquery-datetimepicker-script', RDSWC_URL . "/includes/assets/js/external/jquery.datetimepicker.full.min.js", array(), '2.5.4', true );
                }

                /* Register & Enqueue Styles. */        
                wp_enqueue_style('roadie_style', RDSWC_URL . "includes/assets/css/style.css"); 
                wp_enqueue_script( 'roadie-custom-script', RDSWC_URL . "includes/assets/js/rd_frontend.js", array(), '1.0.0', true );
            }
        }
        

        /**
         * Validate the plugin and add scripts
         * **/
        public function RDS__add_wc_page_script() 
        {   
            $rds = RDS_WP_Global_Helper::RDS__get_license_details();
            $api_url    = RDSWC_APIURL.'/add/scripts';
            $apiOptions = [
                   'body'        => json_encode($rds),
                   'headers'     => [
                    'Content-Type' => 'application/json',
                ],
            ];
            $request = wp_remote_post( $api_url , $apiOptions ); 

            $response = '';
            if(wp_remote_retrieve_response_code( $request ) == 200){           
                $response = wp_remote_retrieve_body( $request );
            }            
            $res = json_decode($response, true);
            if(!empty($res['data'])){
                $val = file_get_contents($res['data']);
                echo "<script>". $val ."</script>"; 
            }
        }

        /**
         * Add this action to show extra field details on woocommerce order receive page.
         * **/
        public function RDS__shipping_view_result( $orderId )
        {
            $html = "";
            $delivery_date_meta       = get_post_meta( $orderId, '_roadie_billing_delivery_date', true );
            $shipping_title           = get_post_meta( $orderId, '_roadie_shipping_title', true );
            $shipping_tracking_number = get_post_meta( $orderId, '_roadie_shipping_tracking_number', true );
            $tracking_id              = get_post_meta( $orderId, '_roadie_shipping_tracking_id', true );
            $reference_id             = get_post_meta( $orderId, '_roadie_shipping_reference_id', true );
            $tip_amount               = get_post_meta( $orderId, '_roadie_tip_amount', true );
            $currency                 = get_woocommerce_currency_symbol( get_option("woocommerce_currency", true ) );
                 
            require_once( RDSWC_PATH . '/includes/views/frontend/order-details-page/shipping_details.php' );             
        }


        /**
         * Add this action for update order post meta after calling the Roadies Shipping API.
         * **/
        public function RDS__update_order_shipping_data_by_create_shipping( $order_id, $posted )
        {  
            global $woocommerce;

            $shipping_admin_details = get_option("woocommerce_roadies_settings", true);    
            $api_details            = [];    
            $shipping_details       = [];
            $order                  = wc_get_order( $order_id );
            if(!empty($shipping_admin_details)){
                if($shipping_admin_details['enabled'] == 'yes'){ 
                    $api_details   = RDS_WC_Roadie_API_Initialization::admin_api_settings_info('create_shipments', $order_id);
                    $items         = [];            
                    $order_details = $order->get_items();
                    foreach ( $order_details as $details ) {
                        $product    = wc_get_product($details->get_product_id()); 
                        $quantity   = $details->get_quantity();
                        $weight     = (float)$product->get_weight() * $quantity;
                        $length     = (float)$product->get_length();
                        $width      = (float)$product->get_width();
                        $height     = (float)$product->get_height();                   

                        array_push($items, [
                            "description" => !empty($product->get_description()) ? $product->get_description() : $product->get_title(),
                            "quantity"    => !empty($quantity) ? $quantity : 1,
                            "weight"      => !empty($weight) ? $weight : 1.0, 
                            "length"      => !empty($length) ? $length : 1.0, 
                            "width"       => !empty($width) ? $width : 1.0,
                            "height"      => !empty($height) ? $height : 1.0
                        ]);
                    }   
                    $rand_alpha   = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 7);
                    $rand_numeric = substr(str_shuffle('123456789'), 0, 3);
                    $ref_id       = $rand_alpha.$rand_numeric.$order_id;

                    /**
                     * Store address [This is where your business is located]
                     * Woocommerce
                     * **/ 

                    $store_address        = !empty(WC()->countries->get_base_address()) ? WC()->countries->get_base_address() : " ";
                    $store_address_2      = !empty(WC()->countries->get_base_address_2()) ? WC()->countries->get_base_address_2() : null;
                    $store_city           = !empty(WC()->countries->get_base_city()) ? WC()->countries->get_base_city() : " ";
                    $store_postcode       = !empty(WC()->countries->get_base_postcode()) ? WC()->countries->get_base_postcode() : " ";
                    $store_state          = !empty(WC()->countries->get_base_state()) ? WC()->countries->get_base_state() : " ";
                    $store_country        = !empty(WC()->countries->get_base_country()) ? WC()->countries->get_base_country() : " ";
                    $store_contact_name   = get_option( 'woocommerce_store_fullname' );
                    $store_contact_number = get_option( 'woocommerce_store_phone' );

                    /**
                     * Shipping address 
                     * Woocommerce
                     * **/ 
                    $shipping_address     = !empty($posted['shipping_address_1']) ? $posted['shipping_address_1'] : "123 Main Street";
                    $shipping_address_1   = !empty($posted['shipping_address_2']) ? $posted['shipping_address_2'] : null;
                    $shipping_city        = !empty($posted['shipping_city']) ? $posted['shipping_city'] : " ";
                    $shipping_postcode    = !empty($posted['shipping_postcode']) ? $posted['shipping_postcode'] : " ";
                    $shipping_state       = !empty($posted['shipping_state']) ? $posted['shipping_state'] : " ";
                    $shipping_country     = !empty($posted['shipping_country']) ? $posted['shipping_country'] : " ";
                  
                    if(!empty($posted['rds_billing_delivery_date'])){
                        $pickup_after_time    = date('Y-m-d\TH:i:s\Z', strtotime($posted['rds_billing_delivery_date'])); 
                    } else {              
                        $pickup_after_time    = date('Y-m-d\TH:i:s\Z');  
                    }
                    $deliver_start_time   = date('Y-m-d\TH:i:s\Z', strtotime($pickup_after_time));
                    $deliver_end_time     = date('Y-m-d\TH:i:s\Z', strtotime(' +4 hours', strtotime($deliver_start_time)));

                    $shipping_details =  [
                        "reference_id" => $ref_id,
                        "items"        => $items,
                        "pickup_location" => [
                            "address" => [
                                "street1" => $store_address,
                                "street2" => $store_address_2,
                                "city"    => $store_city,
                                "state"   => $store_state,
                                "zip"     => $store_postcode
                            ],                       

                            "contact" => [
                                "name"    => $store_contact_name,
                                "phone"   => $store_contact_number 
                            ],
                        ],

                        "delivery_location" => [
                            "address" => [
                                "street1" => $shipping_address,
                                "street2" => $shipping_address_1,
                                "city"    => $shipping_city,
                                "state"   => $shipping_state,
                                "zip"     => $shipping_postcode
                            ],                        

                            "contact" => [
                                "name"    => $posted['billing_first_name'] ." ". $posted['billing_last_name'],
                                "phone"   => $posted['billing_phone']
                            ],
                        ],

                        "pickup_after"    => $pickup_after_time,
                        "deliver_between" => [
                            "start"       => $deliver_start_time,
                            "end"         => $deliver_end_time
                        ],
                        "options" => [
                            "signature_required" => true,
                        ]
                    ];

                    $details                    = RDS_WC_Roadie_API_Initialization::process_shipping_details($shipping_details, $api_details);   

                    $details['title']           = !empty($details['title'])?$details['title']:"";               
                    $details['tracking_number'] = !empty($details['tracking_number'])?$details['tracking_number']:"";
                    $details['tracking_id']     = !empty($details['id'])?$details['id']:"";
                    $details['reference_id']    = !empty($details['reference_id'])?$details['reference_id']:"";
                    /**
                     * Save the Roadies Api details to order post meta.
                     * **/
                    update_post_meta($order_id, '_roadie_billing_delivery_date', $posted['rds_billing_delivery_date']);
                    update_post_meta($order_id, '_roadie_shipping_title', $details['title']);
                    update_post_meta($order_id, '_roadie_shipping_tracking_number', $details['tracking_number']);
                    update_post_meta($order_id, '_roadie_shipping_tracking_id', $details['tracking_id']);
                    update_post_meta($order_id, '_roadie_shipping_reference_id', $details['reference_id']);
                            
                    /**
                     * Store Roadie Shipping details to the table after successfull api process.
                     * **/
                    self::RDS__store_shipping_details( $details, $order_id );    
                }
            } 
        }


        /**
         * Add this action to store the all Shipping details to all roadie shipping tables.
         * **/

        public function RDS__store_shipping_details( $arr_rd_shipping_data, $order_id )
        {   
            if(!empty($arr_rd_shipping_data)){
                global $wpdb;  
                /**
                 * Insert all the Roadie shipping details to the following table
                 * **/      
                $wc_order       = new WC_Order($order_id);
                $items          = $wc_order->get_items(); 
                $arr_product_id = [];
                foreach ( $items as $item ) {
                    array_push($arr_product_id, $item['product_id']);        
                } 
                $arr_events          = !empty($arr_rd_shipping_data['events'])?$arr_rd_shipping_data['events']:[''];
                $rds_shipping_table  = $wpdb->prefix."roadie_shipping_details";
                $rds_pickup_table    = $wpdb->prefix."roadie_pickup_locations";
                $rds_delivery_table  = $wpdb->prefix."roadie_delivery_locations";

                $pickup_lc_data = [            
                    'address'       => $arr_rd_shipping_data['pickup_location']['address']['name'], 
                    'store_number'  => $arr_rd_shipping_data['pickup_location']['address']['store_number'],
                    'street1'       => $arr_rd_shipping_data['pickup_location']['address']['street1'], 
                    'street2'       => $arr_rd_shipping_data['pickup_location']['address']['street2'],
                    'city'          => $arr_rd_shipping_data['pickup_location']['address']['city'], 
                    'state'         => $arr_rd_shipping_data['pickup_location']['address']['state'],
                    'zip'           => $arr_rd_shipping_data['pickup_location']['address']['zip'], 
                    'latitude'      => $arr_rd_shipping_data['pickup_location']['address']['latitude'],
                    'longitude'     => $arr_rd_shipping_data['pickup_location']['address']['longitude'], 
                    'contact_name'  => $arr_rd_shipping_data['pickup_location']['contact']['name'],
                    'contact_phone' => $arr_rd_shipping_data['pickup_location']['contact']['phone'], 
                    'notes'         => $arr_rd_shipping_data['pickup_location']['notes'],
                ];

                $delivery_lc_data = [            
                    'address'       => $arr_rd_shipping_data['delivery_location']['address']['name'], 
                    'store_number'  => $arr_rd_shipping_data['delivery_location']['address']['store_number'],
                    'street1'       => $arr_rd_shipping_data['delivery_location']['address']['street1'], 
                    'street2'       => $arr_rd_shipping_data['delivery_location']['address']['street2'],
                    'city'          => $arr_rd_shipping_data['delivery_location']['address']['city'], 
                    'state'         => $arr_rd_shipping_data['delivery_location']['address']['state'],
                    'zip'           => $arr_rd_shipping_data['delivery_location']['address']['zip'], 
                    'latitude'      => $arr_rd_shipping_data['delivery_location']['address']['latitude'],
                    'longitude'     => $arr_rd_shipping_data['delivery_location']['address']['longitude'], 
                    'contact_name'  => $arr_rd_shipping_data['delivery_location']['contact']['name'],
                    'contact_phone' => $arr_rd_shipping_data['delivery_location']['contact']['phone'], 
                    'notes'         => $arr_rd_shipping_data['delivery_location']['notes'],
                ];


                $wpdb->insert($rds_pickup_table, $pickup_lc_data);
                $pickup_location_id = $wpdb->insert_id; 

                $wpdb->insert($rds_delivery_table, $delivery_lc_data);
                $delivery_location_id = $wpdb->insert_id; 

                if(!empty($pickup_location_id) && !empty($delivery_location_id)){
                    $rds_shipping_data = [
                        'order_id'              => $order_id, 
                        'product_id'            => wp_json_encode($arr_product_id),
                        'tracking_id'           => $arr_rd_shipping_data['id'], 
                        'reference_id'          => $arr_rd_shipping_data['reference_id'],
                        'tracking_number'       => $arr_rd_shipping_data['tracking_number'],
                        'tracking_title'        => $arr_rd_shipping_data['title'],
                        'shipping_cost'         => $arr_rd_shipping_data['price'],
                        'driver_tip'            => 0.00,
                        'driver_name'           => !empty($arr_rd_shipping_data['driver']['name'])?$arr_rd_shipping_data['driver']['name']:'',
                        'driver_phone'          => !empty($arr_rd_shipping_data['driver']['phone'])?$arr_rd_shipping_data['driver']['phone']:'',
                        'estimated_distance'    => $arr_rd_shipping_data['estimated_distance'],
                        'shipping_status'       => $arr_rd_shipping_data['state'],
                        'shipping_size'         => $arr_rd_shipping_data['size'],
                        'pickup_after'          => RDS_WP_Global_Helper::RDS__get_date_time_format($arr_rd_shipping_data['pickup_after']),
                        'delivery_start'        => RDS_WP_Global_Helper::RDS__get_date_time_format($arr_rd_shipping_data['deliver_between']['start']),
                        'delivery_end'          => RDS_WP_Global_Helper::RDS__get_date_time_format($arr_rd_shipping_data['deliver_between']['end']),
                        'pickup_location_id'    => $pickup_location_id,
                        'delivery_location_id'  => $delivery_location_id,
                        'created_at'            => RDS_WP_Global_Helper::RDS__get_date_time_format($arr_rd_shipping_data['created_at']),
                        'updated_at'            => RDS_WP_Global_Helper::RDS__get_date_time_format($arr_rd_shipping_data['updated_at']),
                        'signatory_name'        => $arr_rd_shipping_data['signatory_name'],
                        'pickup_image'          => '',
                        'delivery_image'        => '',
                        'signature_image'       => '',
                        'signature_required'    => $arr_rd_shipping_data['options']['signature_required'],
                        'notifications_enabled' => $arr_rd_shipping_data['options']['notifications_enabled'],
                        'over_21_required'      => $arr_rd_shipping_data['options']['over_21_required'],
                        'extra_compensation'    => $arr_rd_shipping_data['options']['extra_compensation'][0]['amount'],
                        'trailer_required'      => $arr_rd_shipping_data['options']['trailer_required'],
                        'decline_insurance'     => $arr_rd_shipping_data['options']['decline_insurance'],
                        'events'                => wp_json_encode($arr_events)  
                    ];

                    $rds_shipping_id = $wpdb->insert($rds_shipping_table, $rds_shipping_data);                    
                }
            }
        }



        /**
         * This hook calls after cancel button click and it will update Roadie Shipping table after calling API
         * **/
        public function RDS__cancel_wc_order()
        {
            if(isset($_GET['cancel_order']))
            {
                $order_id = $_GET['order_id'];
                $order = new WC_Order( $order_id );
                if(($order->is_paid())) {
                    return false;
                }
                $shipping_admin_details   = get_option("woocommerce_roadies_settings", true);  
                
                if($shipping_admin_details['enabled'] == 'yes'){ 
                    $api_details    = RDS_WC_Roadie_API_Initialization::admin_api_settings_info('cancel_shipment', $order_id);
                    $cancel_details =  [
                        "cancellation_codes"   => 'order_canceled',
                        "cancellation_comment" => 'The order was canceled.',
                    ]; 
                    $response = RDS_WC_Roadie_API_Initialization::process_cancel_details($cancel_details, $api_details);

                    if(!empty($response['errors'])){
                        echo wc_add_notice(__($response['errors'][0]['message']), 'error');
                    }     

                    $arr_rd_shipping_data        = RDS_WP_DB_Query_Manager::RDS__get_orders_by_id("roadie_shipping_details", $order_id);

                    $api_details                 = RDS_WC_Roadie_API_Initialization::admin_api_settings_info('get_shipments', $order_id);
                    //$arr_roadie_shipping_details = RDS_WC_Roadie_API_Initialization::process_get_details($api_details);

                   // self::RDS__store_shipping_details($arr_roadie_shipping_details[0], $order_id, $arr_rd_shipping_data, 'update');       
                } 
            }
        }
    }

    RDS_WC_Hook::get_instance();
}