<?php 

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

if ( ! class_exists( 'Roadie_Rest_Api_Controller' ) ) {
   /**
    * Main plugin class
    *
    * @package Roadie_Rest_Api_Controller 
    * @author Roadie Shipment
    */
   class Roadie_Rest_Api_Controller
   {    
        private $namespace;


        /**
        * Class constructor
        *
        * @access public
        * @return void
        */
        public function __construct()
        {            
            //https://yofidelivery.com/wp-json/rds-shipment/v1/getproducts
            $this->namespace = 'rds-shipment/v1';
        }

        public function register_routes()
        {
            register_rest_route($this->namespace, '/getproducts', [
                [
                    'methods'             => 'GET',
                    'callback'            => [ $this, 'RDS_get_product_plugin_info' ],
                    'permission_callback' => [ $this, 'get_item_permissions_check' ]
                ]
            ]);

            register_rest_route($this->namespace, '/store/plugin_info', [
                [
                    'methods'             => 'POST',
                    'callback'            => [ $this, 'RDS_store_plugin_info' ],
                    'permission_callback' => [ $this, 'get_item_permissions_check' ]
                ]
            ]);

            register_rest_route($this->namespace, '/update/plugin_info', [
                [
                    'methods'             => 'POST',
                    'callback'            => [ $this, 'RDS_update_plugin_info' ],
                    'permission_callback' => [ $this, 'get_item_permissions_check' ]
                ]
            ]);

            register_rest_route($this->namespace, '/product/verifications', [
                [
                    'methods'             => 'POST',
                    'callback'            => [ $this, 'RDS_update_product_verification' ],
                    'permission_callback' => [ $this, 'get_item_permissions_check' ]
                ]
            ]);

            register_rest_route($this->namespace, '/add/scripts', [
                [
                    'methods'             => 'POST',
                    'callback'            => [ $this, 'RDS_validate_script' ],
                    'permission_callback' => [ $this, 'get_item_permissions_check' ]
                ]
            ]);
        }


        /**
         * Check permissions for the posts.
         *
         * @param WP_REST_Request $request Current request.
         */
        public function get_item_permissions_check( $request ) 
        {
            return true;
        }


        public function RDS_get_product_plugin_info( $request ) 
        {
            $response = [ "Roadie Shipping" ];
            return rest_ensure_response( $response );
        }

        public function RDS_update_plugin_info( $request )
        {   
            global $wpdb;
            $reqBody = $request->get_body();
            $postData = json_decode($reqBody, true);  
            $res = [];  
            if(!empty($postData)){               
                if(strpos($postData['plugin_name'], 'Enterprise') !== false){
                    $plan = 3;
                } else if(strpos($postData['plugin_name'], 'Professional') !== false){
                    $plan = 2;
                } else {
                    $plan = 1;
                }

                $tableName = $wpdb->prefix.'roadie_plugin_details';
                $result    = $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `ip_address` = "'. $postData['ip_address'] .'" AND `site_name` = "'. $postData['site_name'] .'" AND `plugin_name` LIKE "%'. $postData['plugin_name'] .'%"', ARRAY_A);                

                if(!empty($result)){
                    $postData['plan']        = $plan;
                    $postData['status']      = $postData['status'];
                    $postData['modified_on'] = $postData['modified_on'];

                    $wpdb->update( $tableName, $postData, ['id' => $result['id'] ], ['%s'], ['%d'] );
                    $res = [ 'status' => true, "msg" => 'updated!', 'last_inserted_id' => $result['id'] ];
                }
            }
            return rest_ensure_response( $res );
        }

        public function RDS_store_plugin_info( $request )
        {
            $reqBody = $request->get_body();
            $postData = json_decode($reqBody, true);  
            $res = [];  
            if(!empty($postData)){               
                if(strpos($postData['plugin_name'], 'Enterprise') !== false){
                    $plan = 3;
                } else if(strpos($postData['plugin_name'], 'Professional') !== false){
                    $plan = 2;
                } else {
                    $plan = 1;
                }

                global $wpdb;
                $tableName = $wpdb->prefix.'roadie_plugin_details';
                $result    = $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `ip_address` = "'. $postData['ip_address'] .'" AND `site_name` = "'. $postData['site_name'] .'" AND `plugin_name` LIKE "%'. $postData['plugin_name'] .'%"', ARRAY_A);

                if(empty($result)){
                    $postData['plan']        = $plan;
                    $postData['status']      = 1;
                    $postData['modified_on'] = date("Y-m-d H:i:s");
                        
                    $wpdb->insert($tableName, $postData);
                    $last_inserted_id = $wpdb->insert_id; 
                    $res = [ 'status' => true, "msg" => '', 'last_inserted_id' => $last_inserted_id ];
                } else {
                    if($result['status'] == 0){                        
                        $postData['plan']        = $plan;
                        $postData['status']      = 1;
                        $postData['modified_on'] = date("Y-m-d H:i:s");
                        $wpdb->update( $tableName, $postData, ['id' => $result['id'] ], ['%s'], ['%d'] );
                    }
                }
            } 
            return rest_ensure_response( $res );
        }

        public function RDS_update_product_verification( $request )
        {
            $reqBody  = $request->get_body();
            $postData = json_decode($reqBody, true);
            $res      = [];   

            global $wpdb;
            if(!empty($postData)){

                $exist_key = $this->check_existing_key_token($postData);
                if(empty($exist_key)){
                    $valid = $this->RDS_validate_key_token($postData);   
                    if($valid){
                        $tableName = $wpdb->prefix.'roadie_plugin_details';
                        $result = $this->get_row_details($tableName, $postData, 1);
                    
                        if(empty($result)){  
                            $license_data  = $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `ip_address` = "'. $postData['ip_address'] .'" AND `site_name` = "'. $postData['site_name'] .'" AND `plugin_name` LIKE "%'. $postData['plugin_name'] .'%" ', ARRAY_A);
                            
                            $postData['status']      = 1;
                            $postData['validate_on'] = date("Y-m-d H:i:s");
                            $postData['modified_on'] = date("Y-m-d H:i:s");
                            if(strpos($postData['plugin_name'], 'Basic') !== false){                                
                                $postData['website_count'] = 1;
                            } else if(strpos($postData['plugin_name'], 'Professional') !== false){
                                $postData['website_count'] = $license_data['website_count']+1;
                            } else {                                
                                $postData['website_count'] = 'unlimited';
                            }

                            $wpdb->update( $tableName, $postData, ['id' => $license_data['id'] ], ['%s'], ['%d'] );                   
                            $res = ['status' => true, "msg" => 'Your license key is activated.', "data" => $postData];

                        } else {                            
                            $res = ['status' => false, "msg" => 'License key is already used in another site. Please try with exact key and token.', "data" => $postData ];
                        }
                    } else {
                        $res = ['status' => false, "msg" => 'License key is invalid. Please try again.', "data" => [] ];
                    }
                } else {
                    $res = ['status' => false, "msg" => 'License key is already exists on another system. Please try with exact key and token.', "data" => $postData ];
                }
            } else {
                $res = ['status' => false, "msg" => 'License key & secret key are required.', "data" => [] ];
            }
            return rest_ensure_response( $res );
        }

        public function RDS_validate_key_token( $posted ){
            global $wpdb;
            $tableName = $wpdb->prefix.'postmeta';
            $result    = $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `meta_value` = "'. $posted['activation_key'] .'"', ARRAY_A);
            $order = wc_get_order( $result['post_id'] );
            $items = $order->get_items();
            $product_name = "";
            foreach ( $items as $item ) {
                $product_name = $item->get_name();
            }

            $response = false;
            if(!empty($result)){
                if (strpos($posted['plugin_name'], $product_name) !== false) {                    
                    $response = true;
                }
            }
            return $response;
        }

        public function RDS_validate_script( $request )
        {            
            global $wpdb;
            $reqBody  = $request->get_body();
            $postData = json_decode($reqBody, true);
            $res      = ['status' => false, 'msg' => '', 'data' => ''];
            if(empty($postData) || empty($postData['key']) || empty($postData['token'])){
                $script = $this->generate_script();
                $res = ['status' => true, 'msg' => 'Script added successfully', 'data' => $script];
            } else {
                $tableName = $wpdb->prefix.'roadie_plugin_details';
                $result = $this->get_row_details($tableName, $postData, 2);
                if(!empty($result)){                    
                    $script = $this->generate_script();
                    $res = ['status' => true, 'msg' => 'Script added successfully', 'data' => $script];
                } else{                   
                    $res = ['status' => false, 'msg' => '', 'data' => ''];
                }
            }
            return rest_ensure_response($res);
        }

        public function get_row_details( $tableName, $postData, $type ){
            global $wpdb;
            if($type == 2){
                return $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `activation_token` = "'. $postData['token'] .'" AND `ip_address` = "'. $postData['ip_address'] .'" AND `site_name` = "'. $postData['site_name'] .'" AND `plugin_name` LIKE "%'. $postData['plugin_name'] .'%"', ARRAY_A);
            } else {
                if(strpos($postData['plugin_name'], 'Basic') !== false){                    
                    return $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `activation_token` = "'. $postData['activation_token'] .'" AND `ip_address` = "'. $postData['ip_address'] .'" AND `site_name` = "'. $postData['site_name'] .'" AND `plugin_name` LIKE "%'. $postData['plugin_name'] .'%" AND `website_count` = 1', ARRAY_A);
                } elseif(strpos($postData['plugin_name'], 'Professional') !== false){ 
                    return $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `activation_token` = "'. $postData['activation_token'] .'" AND `ip_address` = "'. $postData['ip_address'] .'" AND `site_name` = "'. $postData['site_name'] .'" AND `plugin_name` LIKE "%'. $postData['plugin_name'] .'%"  AND `website_count` = 4 ', ARRAY_A);
                } else {                    
                    return $wpdb->get_row('SELECT * FROM '. $tableName .' WHERE `activation_token` = "'. $postData['activation_token'] .'" AND `ip_address` = "'. $postData['ip_address'] .'" AND `site_name` = "'. $postData['site_name'] .'" AND `plugin_name` LIKE "%'. $postData['plugin_name'] .'%"', ARRAY_A);
                }
            }            
        }

        public function check_existing_key_token( $postData ){
            global $wpdb;
            return $wpdb->get_row('SELECT * FROM '. $wpdb->prefix.'roadie_plugin_details WHERE `activation_token` = "'. $postData['activation_token'] .'" AND `activation_key` = "'. $postData['activation_key'] .'"', ARRAY_A);
        }

        public function generate_script () {    
            // $script  = "<script type='text/javascript'>";
            // $script .= "jQuery(document).ready(function(){";               
            //     $script .= "jQuery('.add-tip-woocommerce').remove(); ";        
            //     $script .= "jQuery('#rds_billing_delivery_date').removeAttr('id'); ";
            //     $script .= "jQuery('.shipping_method').val(' '); ";
            // $script .= "});";
            // $script .= "</script>";

            $script = "https://yofidelivery.com/wp-content/plugins/roadie-shipping-plugin-manager/assets/js/yofiscript.js";
            return $script;
        }

    }

}
add_action('rest_api_init', function() 
{
    $controller = new Roadie_Rest_Api_Controller();
    $controller->register_routes();
});