<?php 
/**
 * Plugin Name: Roadie Shipping Plugin Manager
 * Plugin URI: https://docs.roadie.com/#api-overview
 * Description: This plugin is for connecting the API routes.
 * Author: Pipopie LLC
 * Version: 1.0.0
 * Tested up to: 6.0.1
 * License: GNU General Public License v3.0
 */

/**
* @package Roadie Shipping Plugin Manager
* @author  Pipopie LLC
* @license GPL-3.0+
* @link    http://www.gnu.org/licenses/gpl-3.0.html
**/


// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

// Make sure WooCommerce is active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    return;
}

if ( ! class_exists( 'Roadie_Shipping_Plugin_Manager' ) ) {
   /**
    * Main plugin class
    *
    * @package Roadie_Shipping_Plugin_Manager 
    * @author Roadie Shipment
    */
   class Roadie_Shipping_Plugin_Manager
   {  
        /**
        * Class constructor
        *
        * @access public
        * @return void
        */
        public function __construct()
        {
            require_once(dirname(__FILE__) . "/class-roadie-rest-api.php");
        }
    }

    $obj_Roadie_Shipping_Plugin_Manager = new Roadie_Shipping_Plugin_Manager();
}