<?php
 /* Template Name: Post template */
get_header();
?>
<div class="wrapper pt-3" id="page-wrapper">
    <section class="sky-blue pt-70 pb-70 m-top">
       <div class="section-tittle text-center">
          <h2 class="m-0 font-size-40"> <?php echo get_the_title();?></h2>
        </div>
    </section>

    <section class="section-padding">
      <div class="container">
         <div class="row">
    	    <?php
             $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
              $args = array(
                        'post_type'   => 'post',
    			              'post_status' => 'publish',
                        'posts_per_page' => 3,
                        'order' => 'DESC',
                        'paged' => $paged, 
                      );
    		      $custom_query = new WP_Query( $args );
              if ( $custom_query->have_posts() ) {
                while ( $custom_query->have_posts() ) {
                $custom_query->the_post();
    		      		
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
          ?> 
    	   <div class="col-lg-12 col-md-12 col-sm-12 blog-mb">
    	     <div class="card">
               <img class="card-img-top" src="<?php echo $featured_img_url ?>" alt="Card image cap">
                  <div class="card-body">
                  
                    <!-- Title -->
                    <ul class="blog-info">
                       <li class="blog-info-item"><i class="fa fa-calendar" aria-hidden="true"></i><?php echo get_the_date( 'Y-m-d' ); ?></li>
                       <li class="blog-info-item"><i class="fa fa-user" aria-hidden="true"></i><?php echo get_the_author(); ?></li>
                    </ul>
                    <h4 class="card-title"><a><?php the_title(); ?></a></h4>
                    <!-- Text -->
                    <p class="card-text"><?php $content = get_the_content(); echo wp_trim_words( $content, 30, '...' );?>  
                    </p>
                    <!-- Button -->
                    <a href="<?php echo get_permalink(); ?>" class="blog-link">Read More</a>              
                  </div>
               </div>
    	   </div>
    	   <?php }
          $total_pages = $custom_query->max_num_pages; 
          ?>
            <div class="pagination-wraper">
              <?php
                if ($total_pages > 1){

                    $current_page = max(1, get_query_var('paged'));

                    echo paginate_links(array(
                        'base' => get_pagenum_link(1) . '%_%',
                        'format' => '/page/%#%',
                        'current' => $current_page,
                        'total' => $total_pages,
                        //'after_page_number'  => '.',
                        'prev_text'    => __('« prev'),
                        'next_text'    => __('next »'),
                    ));
                } ?>        
            </div>
            <?php } wp_reset_postdata(); ?> 
    	 </div>
      </div>
    </section>
</div>
<!--==========================Footer============================-->
<?php get_footer();?>