<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after
 *
 * @package Understrap
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$container = get_theme_mod( 'understrap_container_type' );
?>

<?php get_template_part( 'sidebar-templates/sidebar', 'footerfull' ); ?>

<div class="wrapper" id="wrapper-footer">

	<section class="say-something-aera pt-90 pb-90 fix sky-blue">
		<div class="container">
			<?php dynamic_sidebar( 'footer-top' ); ?>
		</div>
		<div class="say-shape">
			<img
			src="<?php echo get_stylesheet_directory_uri() ?>/assets/img/shape/say-shape-left.png"
			alt=""
			class="say-shape1 rotateme d-none d-xl-block"
			/>
			<img
			src="<?php echo get_stylesheet_directory_uri() ?>/assets/img/shape/say-shape-right.png"
			alt=""
			class="say-shape2 d-none d-lg-block"
			/>
		</div>
	</section>

	<div class="<?php echo esc_attr( $container ); ?>">

		<div class="row">

			<div class="col-md-12">

				<footer class="site-footer" id="colophon">

					<div class="footer-main">
						<div class="footer-area footer-padding">
							<div class="container">
								<div class="row justify-content-between">
									<div class="col-lg-4 col-md-4 col-sm-8">
										<?php dynamic_sidebar( 'footer-1' ); ?>
									</div>
									<div class="col-lg-2 col-md-4 col-sm-5">
										<?php dynamic_sidebar( 'footer-2' ); ?>
									</div>
									<div class="col-lg-3 col-md-4 col-sm-7">
										<?php dynamic_sidebar( 'footer-3' ); ?>
									</div>
									<div class="col-lg-3 col-md-6 col-sm-8">
										<?php dynamic_sidebar( 'footer-4' ); ?>
									</div>
								</div>
								<div class="row align-items-center">
									<div class="col-xl-12">										
										<?php dynamic_sidebar( 'footer-bottom' ); ?>
									</div>
								</div>
							</div>
						</div>
					</div>

				</footer><!-- #colophon -->

			</div><!-- col -->

		</div><!-- .row -->

	</div><!-- .container(-fluid) -->

</div><!-- #wrapper-footer -->

</div><!-- #page -->
<?php // Closing div#page from header.php. ?>
</div><!-- #page -->

<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/vendor/modernizr-3.5.0.min.js' ?>"></script>

<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/owl.carousel.min.js' ?>"></script>
<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/slick.min.js' ?>"></script>

<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/wow.min.js' ?>"></script>
<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/animated.headline.js' ?>"></script>

<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/jquery.scrollUp.min.js' ?>"></script>
<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/jquery.sticky.js' ?>"></script>

<script src="<?php echo get_stylesheet_directory_uri(). '/assets/js/main.js' ?>"></script>

<?php wp_footer(); ?>

</body>

</html>

