<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
	function chld_thm_cfg_locale_css( $uri ){
		if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
			$uri = get_template_directory_uri() . '/rtl.css';
		return $uri;
	}
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

function chld_thm_cfg_parent_css() {
	wp_enqueue_style( 'chld_thm_cfg_parent', trailingslashit( get_template_directory_uri() ) . 'style.css', array( 'font-awesome','simple-line-icons','icofont-min','owl-carousel','pretty-css','editor-styles' ) );
     wp_enqueue_style( 'child-style', get_stylesheet_uri() );
	wp_enqueue_style( 'owl-carousel-style', get_stylesheet_directory_uri(). '/assets/css/owl.carousel.min.css', 'true' );
	wp_enqueue_style( 'animate-style', get_stylesheet_directory_uri(). '/assets/css/animate.min.css', 'true' );
	wp_enqueue_style( 'font-awesome-style', get_stylesheet_directory_uri(). '/assets/css/fontawesome-all.min.css', 'true' );
	wp_enqueue_style( 'themify-style', get_stylesheet_directory_uri(). '/assets/css/themify-icons.css', 'true' );
	wp_enqueue_style( 'slick-css', get_stylesheet_directory_uri(). '/assets/css/slick.css', 'true' );
	wp_enqueue_style( 'style-css', get_stylesheet_directory_uri(). '/assets/css/style.css', 'true' );
	wp_enqueue_style( 'responsive-css', get_stylesheet_directory_uri(). '/assets/css/responsive.css', 'true' );
}
add_action( 'wp_enqueue_scripts', 'chld_thm_cfg_parent_css', 1000 );
//change loginpage logo

function wpb_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(http://yofidelivery.com/wp-content/uploads/2022/12/logo.png);
        height:100px;
        width:138px;
        background-size: cover;
        background-repeat: no-repeat;
        padding-bottom: 10px;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'wpb_login_logo' );
//change loginpage logo url
function wpb_login_logo_url() {
    return home_url();
}
add_filter( 'login_headerurl', 'wpb_login_logo_url' );

//footer widget


function yofi_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer top', 'yofi' ),
			'id'            => 'footer-top',
			'description'   => esc_html__( 'Add widgets here for footer top.', 'yofi' ),
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'yofi' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here for footer 1.', 'yofi' ),
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'yofi' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here for footer 2.', 'yofi' ),
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'yofi' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here for footer 3.', 'yofi' ),
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 4', 'yofi' ),
			'id'            => 'footer-4',
			'description'   => esc_html__( 'Add widgets here for footer 4.', 'yofi' ),
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Botton', 'yofi' ),
			'id'            => 'footer-bottom',
			'description'   => esc_html__( 'Add widgets here for footer bottom.', 'yofi' ),
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	
}
add_action( 'widgets_init', 'yofi_widgets_init' );


/*=============================================================*/
/*
 * Change button text on shop pages
 */
add_filter( 'woocommerce_product_single_add_to_cart_text', function ( $product ){
    return 'Buy Now';
});


/**
 * Change mesage html in to cart page.
 * */
add_filter( 'woocommerce_product_add_to_cart_text', function ( $text, $product ){
    return $product->is_purchasable() && $product->is_in_stock() ? 'Buy Now' : 'Read more';
}, 10, 2 );


/**
 * Change mesage html in to cart page.
 * */
add_filter( 'wc_add_to_cart_message_html', function ( $message, $products ){
    foreach( $products as $product_id => $quantity ){
        // (If needed) get the WC_Product object
        $product = wc_get_product( $product_id );
        $product_title = $product->get_title();
        return __( '"'.$product_title . '" has been added to your checkout.');
    }
    return $message;
}, 10, 2 );


/**
 * The "woocommerce_add_cart_item_data" filter fires every time a new item is added to the cart. We use this chance to call "wc_empty_cart" which empties the cart and optionally the persistent cart too. The new items is therefore alone in the cart.
 * */
add_filter('woocommerce_add_cart_item_data', function($cart_data) {
    wc_empty_cart();
    return $cart_data;
}, 99);


/**
 * Change error message after added extra product in to cart and checkout page.
 * */
add_filter('woocommerce_cart_product_cannot_add_another_message', function ($message, $product_data){
    $message = sprintf( __( 'Sorry, you can only purchase one &quot;%s&quot; at a time.', 'woocommerce' ), $product_data->get_name() );
    return $message;
}, 10, 2);


/**
 * Remove Shipping Address section from Checkout form
 * */
add_filter( 'woocommerce_cart_needs_shipping_address', '__return_false');


/**
 * Remove Additional Details section from Checkout form
 * */
add_filter('woocommerce_enable_order_notes_field', '__return_false');


/**
 * Change the 'Billing & Shipping' checkout label
 * */
function wc_billing_field_strings( $translated_text, $text, $domain ) {
	switch ( $translated_text ) {
		case 'Billing &amp; Shipping' :
		$translated_text = __( 'Billing info', 'woocommerce' );
		break;
	}
	return $translated_text;
}
add_filter( 'gettext', 'wc_billing_field_strings', 20, 3 );



/*=============================================================*/

add_filter( 'pre_get_posts', 'fwp_archive_per_page' );
function fwp_archive_per_page( $query ) {
    if ( is_tax( 'product_cat' ) || is_post_type_archive('product') ) {

        $query->set( 'post_status', 'publish' );
    }
}

add_action( 'woocommerce_checkout_update_order_meta', function ( $orderId, $posted ){
    global $current_user;
    wp_get_current_user();
    $strEncrypt = $orderId."-".$posted['billing_email']."-".date("Y-m-d H:i:s"); 
    
    $activation_key           = produceKey($orderId);
    $activation_access_token  = encipher($strEncrypt, $current_user->user_login, "base64");
    update_post_meta($orderId, '_rds_activation_key', $activation_key);
    update_post_meta($orderId, '_rds_activation_access_token', $activation_access_token);
}, 10, 2 );


/**
 * Add plugin 'Accress Limit' custom meta field in Product post type general tab.
 * */
add_action( 'woocommerce_product_options_general_product_data', function (){
	echo '<div class="options_group">';
	woocommerce_wp_text_input(
		[
			'id'          => 'access_limit',
			'label'		  => sanitize_text_field( 'Website access Limit' ),
			'value'   	  => get_post_meta( get_the_ID(), '_rds_website_access_limit', true ),
			'desc_tip' 	  => true,
			'description' => 'Number of website use limit.',
		]
	);
	echo '</div>';
});

add_action( 'woocommerce_process_product_meta', function ( $id ){
	if( !empty( $_POST[ 'access_limit' ] ) ){
		update_post_meta( $id, '_rds_website_access_limit', $_POST[ 'access_limit' ] );
	}

});

/**
 * Redirect WooCommerce Shop URL
 */
add_filter( 'woocommerce_return_to_shop_redirect', function (){
	return site_url() . '/pricing-plan';
});

add_action( 'woocommerce_admin_order_data_after_order_details', function ($order){
	$activation_key   = get_post_meta( $order->get_id(), '_rds_activation_key', true );
    $activation_token = get_post_meta( $order->get_id(), '_rds_activation_access_token', true );
    if(!empty($activation_key) && !empty($activation_token)){
    	echo '<div class="form-field form-field-wide wc-customer-user">
			    <h3>'.__("Plan details").': </h3>
			    <span style="display:block;padding: 10px 10px 6px 10px;">
			        <strong>'. __("License Key") .':</strong> 
			        <span>'. $activation_key .'</span>
			    </span>
			    <span style="display:block;padding: 0px 10px 6px 10px;">
			        <strong>'. __("Secret Key") .':</strong> 
			        <span>'. $activation_token .'</span>
			    </span>
			</div>';
	}
}, 10);

add_filter( 'manage_edit-shop_order_columns', function ($columns) {
    $reordered_columns = [];
    foreach( $columns as $key => $column){
        $reordered_columns[$key] = $column;
        if( $key ==  'order_status' ){
            $reordered_columns['ip_address']  = __( 'IP Address','theme_domain');
            $reordered_columns['site_name']   = __( 'Site Name','theme_domain');
            $reordered_columns['plan_status'] = __( 'Plan Status','theme_domain');
            $reordered_columns['validate_on'] = __( 'Activation Date','theme_domain');
        }
    }
    return $reordered_columns;
}, 20 );


add_action( 'woocommerce_subscription_payment_complete', 'subscription_renewal_payment_complete');
function subscription_renewal_payment_complete( $subscription  ){
    $subscription_next_payment_date = date( 'Y-m-d H:i:s', strtotime( '-4 hours', strtotime( $subscription->get_date('end') )) );
	update_post_meta($subscription->get_id(), '_schedule_next_payment', $subscription_next_payment_date);
    $new_dates = array(
        // 'start' 	   => $subscription->get_date('start'),
        // 'trial_end'    => $subscription->get_date('trial_end'),
        'next_payment' => $subscription_next_payment_date,
        // 'last_payment' => $subscription->get_date('last_payment'),
        // 'end' 		   => $subscription->get_date('end'),
    );
	$subscription->update_dates($new_dates);
}

// add_action( 'woocommerce_subscription_renewal_payment_complete', 'subscription_renewal_payment_complete2', 11, 2 );
function subscription_renewal_payment_complete2( $subscription, $order ){
    $subscription_id    = $subscription->get_id();
    $order_id           = $order->get_id();
    $billing_email      = $subscription->get_billing_email();
    $next_payment       = $subscription->get_date('next_payment', 'site');
}



function addAsterisk($str, $length){
    return substr($str, 0, 3) . str_repeat("*", $length) . substr($str, -3);
}

function produceKey($orderId){
    return base64_encode(hash_hmac('sha256', $orderId, mt_rand(), true)); 
}

function encipher($str, $pwd, $encoding = null) {
    if ($str != null && $pwd != null) {
        $keysalt = openssl_random_pseudo_bytes(16);
        $key = hash_pbkdf2("sha512", $pwd, $keysalt, 20000, 32, true);
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length("aes-256-gcm"));
        $tag = "";
        $encryptedstring = openssl_encrypt($str, "aes-256-gcm", $key, OPENSSL_RAW_DATA, $iv, $tag, "", 16);
        return $encoding == "hex" ? bin2hex($keysalt.$iv.$encryptedstring.$tag) : ($encoding == "base64" ? base64_encode($keysalt.$iv.$encryptedstring.$tag) : $keysalt.$iv.$encryptedstring.$tag);
    }
}

function decipher($encipher_str, $pwd, $encoding = null) {
    if ($encipher_str != null && $pwd != null) {
        $encipher_str = $encoding == "hex" ? hex2bin($encipher_str) : ($encoding == "base64" ? base64_decode($encipher_str) : $encipher_str);
        $keysalt = substr($encipher_str, 0, 16);
        $key = hash_pbkdf2("sha512", $pwd, $keysalt, 20000, 32, true);
        $ivlength = openssl_cipher_iv_length("aes-256-gcm");
        $iv = substr($encipher_str, 16, $ivlength);
        $tag = substr($encipher_str, -16);
        return openssl_decrypt(substr($encipher_str, 16 + $ivlength, -16), "aes-256-gcm", $key, OPENSSL_RAW_DATA, $iv, $tag);
    }
}

