<?php
/**
 * The header for our theme
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package Understrap
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$bootstrap_version = get_theme_mod( 'understrap_bootstrap_version', 'bootstrap4' );
$navbar_type       = get_theme_mod( 'understrap_navbar_type', 'collapse' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<meta name="description" content="" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="manifest" href="<?php echo get_stylesheet_directory_uri(). '/assets/img/favicon_io/site.webmanifest' ?>" />
    <link rel="manifest" href="/site.webmanifest" />
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo get_stylesheet_directory_uri(). '/assets/img/favicon_io/favicon.ico' ?>"/>
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri(). '/assets/img/favicon_io/apple-touch-icon.png' ?>" />
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_stylesheet_directory_uri(). '/assets/img/favicon_io/favicon-32x32.png' ?>" />
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_stylesheet_directory_uri(). '/assets/img/favicon_io/favicon-16x16.png' ?>" />
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> <?php understrap_body_attributes(); ?>>
<?php do_action( 'wp_body_open' ); ?>
<div class="site" id="page">

    <div class="page-wrapper">
	<!-- ******************* The Navbar Area ******************* -->
	<header id="wrapper-navbar">

		<!-- <a class="skip-link" href="#content"><?php esc_html_e( 'Skip to content', 'understrap' ); ?></a> -->

		<?php //get_template_part( 'global-templates/navbar', $navbar_type . '-' . $bootstrap_version ); ?>

        <div class="header-area header-transparrent">
          <div class="main-header header-sticky">
            <!-- <div id="burger"></div> -->
            <div class="container">
              <div class="row align-items-center">
                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-6 col-xs-6">
                  <div class="logo">
                    <a href="/"
                      ><img src="<?php echo get_stylesheet_directory_uri(). '/assets/img/logo/logo.png'?>" alt=""
                    /></a>
                  </div>
                </div>
                <div class="col-xl-10 col-lg-10 col-md-10 col-sm-6 col-xs-6">
                  <div class="main-menu f-right d-lg-block">
                    <nav>
                      <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
                    </nav>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
	</header><!-- #wrapper-navbar -->
