<?php
/* Template Name: Home */
get_header();
?>
<section class="slider-area sky-blue">
  <div class="slider-active hero-slider">
    <?php
      $args = array(
        'post_type'   => 'slider',
        'posts_per_page' => 6,
      );
      $custom_query = new WP_Query( $args );
      if ( $custom_query->have_posts() ) {
        while ( $custom_query->have_posts() ) {
          $custom_query->the_post();
          
          $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
          ?>           
        <div class="single-slider slider-height slider-padding d-flex align-items-center">
          <div class="container">
            <div class="row d-flex align-items-center">
              <div class="col-lg-6 col-md-12">
                <div class="hero__caption">
                  <span data-animation="fadeInUp" data-delay=".4s"><?php if( get_field('subtitle') ): ?>
                    <?php the_field('subtitle'); ?>
                    <?php endif; ?>                  
                  </span>
                  <h1 data-animation="fadeInUp" data-delay=".6s">
                    <?php if( get_field('title') ): ?>
                      <?php the_field('title'); ?>
                    <?php endif; ?>
                  </h1>
                  <p data-animation="fadeInUp" data-delay=".8s">
                    <?php the_content(); ?>	
                  </p>
                  <div class="slider-btns">
                    <a
                    data-animation="fadeInLeft"
                    data-delay="1.0s"
                    href="<?php if( get_field('button_link') ): ?>
                    <?php the_field('button_link'); ?>
                    <?php endif; ?>"
                    class="btn radius-btn"
                    >Learn More</a
                    >
                  </div>
                </div>
              </div>
              <div class="col-lg-6 col-md-12">
                <div class="hero__img f-right" data-animation="fadeInRight" data-delay="1s" >
                  <img src="<?php echo $featured_img_url ?>" alt="" />
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php
       }
      }
      wp_reset_postdata();
    ?>       
  </div>
</section>  
    
<section class="service-area section-padding2">
  <div class="container">
    <div class="row d-flex justify-content-center">
      <div class="col-lg-6">
        <div class="section-tittle text-center">
          <h2><?php if( get_field('section_one_title') ): ?>
          <?php the_field('section_one_title'); ?>
          <?php endif; ?></h2>
        </div>
      </div>
    </div>
    <div class="row row-gap-5">
      <?php
        $args = array(
          'post_type'   => 'delivery_features',
          'posts_per_page' => 6,
          'order' => 'ASC'
        );
        $custom_query = new WP_Query( $args );
        if ( $custom_query->have_posts() ) {
          while ( $custom_query->have_posts() ) {
            $custom_query->the_post();
            
            $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
            ?> 
            <div class="col-xl-4 col-lg-4 col-md-6">
              <div class="services-caption text-center">
                <div class="service-icon">
                  <span class="flaticon">
                    <img
                    src="<?php echo $featured_img_url ?>"
                    alt=""
                    />
                  </span>
                </div>
                <div class="service-cap">
                  <h4><a href="<?php if( get_field('title_button_link') ): ?>
                  <?php the_field('title_button_link'); ?>
                  <?php endif; ?>"><?php the_title(); ?></a></h4>
                  <p>
                    <?php the_content(); ?>
                  </p>
                </div>
              </div>
            </div>
            <?php
          }
        }
        wp_reset_postdata();
      ?> 
    </div>
  </div>
</section>

<section class="available-app-area integrations-wrap">
  <div class="container">
    <div class="row d-flex justify-content-between align-items-center">
      <div class="col-xl-6 col-lg-6">
        <div class="app-caption mb-50">
          <div class="section-tittle section-tittle3">
            <h2><?php if( get_field('section_two_tutle') ): ?>
            <?php the_field('section_two_tutle'); ?>
            <?php endif; ?></h2>
            <p>
              <?php if( get_field('section_two_content') ): ?>
                <?php the_field('section_two_content'); ?>
              <?php endif; ?>
            </p>
            
          </div>
        </div>
      </div>
      <div class="col-xl-6 col-lg-6">
        <div class="row row-gap-5">
          <?php
            $args = array(
              'post_type'   => 'integration',
              'posts_per_page' => 9,
              'order' => 'ASC'
            );
            $custom_query = new WP_Query( $args );
            if ( $custom_query->have_posts() ) {
              while ( $custom_query->have_posts() ) {
                $custom_query->the_post();
                
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
                ?> 
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">
                  <div class="single-features">
                    <div class="features-icon">
                      <span class="layer-one">
                        <img src="<?php echo $featured_img_url ?>" alt="" />
                      </span>
                      <span class="layer-two">
                        <img src="<?php echo $featured_img_url ?>" alt="" />
                      </span>
                    </div>
                    <div class="features-caption">
                      <h3><?php the_title(); ?></h3>
                    </div>
                  </div>
                </div>
                <?php
              }
            }
            wp_reset_postdata();
          ?>  
        </div>
      </div>
    </div>
  </div>
  <div class="app-shape">
    <img
    src="<?php echo get_stylesheet_directory_uri() ?>/assets/img/shape/app-shape-top.png"
    alt=""
    class="app-shape-top heartbeat d-none d-lg-block"
    />
    <img
    src="<?php echo get_stylesheet_directory_uri() ?>/assets/img/shape/app-shape-left.png"
    alt=""
    class="app-shape-left d-none d-xl-block"
    />
  </div>
</section>

<section class="applic-apps section-padding2 sky-blue">
  <div class="container-fluid">
    <div class="row justify-content-center">
      <div class="col-xl-7 col-lg-8 col-md-9">
        <div class="single-cases-info mb-30">
          <h3><?php if( get_field('section_three_title') ): ?>
          <?php the_field('section_three_title'); ?>
          <?php endif; ?></h3>
          <p>
            <?php if( get_field('section_three_sub_title') ): ?>
              <?php the_field('section_three_sub_title'); ?>
            <?php endif; ?>
          </p>
        </div>
      </div>
    </div>
    <div class="row justify-content-center">
      <div class="col-xl-8 col-lg-8 col-md-col-md-7">
        <div class="plugin-active owl-carousel">
          <?php
            $args = array(
              'post_type'   => 'plugin_screen',
              'posts_per_page' => -1,
              'order' => 'ASC'
            );
             $custom_query = new WP_Query( $args );
             if ( $custom_query->have_posts() ) {
              while ( $custom_query->have_posts() ) {
                $custom_query->the_post();
                
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
                ?> 
                <div class="single-cases-img">
                  <img src="<?php echo $featured_img_url ?>" alt="" />
                </div>
                <?php
              }
            }
            wp_reset_postdata();
          ?>           
        </div>
      </div>
    </div>
  </div>
</section>

<section class="best-pricing pricing-padding">
  <div class="container">
    <div class="row d-flex justify-content-center">
      <div class="col-lg-6 col-md-8">
        <div class="section-tittle section-tittle2 text-center">
          <h2 class="mb-3">Choose Your Very Best
          Pricing Plan</h2>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="pricing-card-area minus-mt">
   <div class="container">
        <div class="row">
          <?php
            $arr_product = wc_get_products([
              'status'=> 'publish',
              'limit' => 3,
              'order' => 'ASC'
            ]); 
            foreach( $arr_product as $product ){ ?>
                <div class="col-xl-4 col-lg-4 col-md-6">
                  <div class="single-card text-center mb-30">
                    <div class="card-top">
                      <span><?php echo $product->get_title(); ?></span>
                      <h4>
                        <?php
                          $currency = get_option("woocommerce_currency", true);
                          if( $product->is_type('simple') ) {  
                            if(!empty($product->get_sale_price())){                        
                              echo "$ ".$product->get_sale_price();
                            } else {
                              echo "$ ".$product->get_regular_price();
                            }
                          }
                         ?>  
                        <span>/ one time</span>                         
                      </h4>
                      <small><?php echo get_post_meta($product->get_id(), "_rds_website_access_limit", true); ?> website.</small>
                    </div>
                    <div class="card-bottom">
                      <?php $product_details = $product->get_data();
                        echo $product_details['description']; ?>
                      <a href="/checkout/?add-to-cart=<?php  echo $product->get_id(); ?>" class="btn card-btn1" > 
                        Buy Now
                      </a>
                    </div>
                  </div>
                </div>
            <?php }  
            wp_reset_postdata();
          ?> 

        </div>
      </div>
</section>

<section class="our-customer section-padd-top30">
  <div class="container-fluid">
    <div class="our-customer-wrapper">
      <div class="row d-flex justify-content-center">
        <div class="col-xl-8">
          <div class="section-tittle text-center">
            <h2>
              <?php if( get_field('testimonial_section_title') ): ?>
                <?php the_field('testimonial_section_title'); ?>
              <?php endif; ?>
            </h2>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-12">
          <div class="customar-active dot-style d-flex dot-style">
            <?php
              $args = array(
                'post_type'   => 'testimonial',
                'posts_per_page' => -1,
                'order' => 'ASC'
              );
              $custom_query = new WP_Query( $args );                            
              if ( $custom_query->have_posts() ) {
                while ( $custom_query->have_posts() ) {
                  $custom_query->the_post();
                  
                  $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
                  ?> 
                  <div class="single-customer">
                    <div class="what-img">
                      <img src="<?php echo $featured_img_url ?>" alt="" />
                    </div>
                    <div class="what-cap">
                      <h4><a href="#"><?php the_title(); ?></a></h4>
                      <p>
                        <?php the_content(); ?>
                      </p>
                    </div>
                  </div>
                  <?php
                }
              }
              wp_reset_postdata();
            ?>           
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!--==========================Footer============================-->
<?php get_footer();?>