<?php /* Template Name: Pricing */
get_header();?>

<section class="wrapper pt-3" id="page-wrapper">
  <div class="sky-blue pt-70 pb-70 m-top">
     <div class="section-tittle text-center">
        <h2 class="m-0 font-size-40"> <?php echo get_the_title();?> </h2>
      </div>
  </div>

  <div class="best-pricing best-pricing2 pricing-padding2">
    <div class="container">
      <div class="row d-flex justify-content-center">
        <div class="col-lg-6 col-md-8">
          <div class="section-tittle text-center">
            <h2><?php the_content(); ?></h2>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="pricing-card-area price-card">
      <div class="container">
        <div class="switches-container">
          <input type="radio" id="switchMonthly" name="switchPlan" value="Monthly" checked="checked" />
          <input type="radio" id="switchYearly" name="switchPlan" value="Yearly" />
          <label for="switchMonthly">Monthly</label>
          <label for="switchYearly">Yearly</label>
          <div class="switch-wrapper">
            <div class="switch">
              <div>Monthly</div>
              <div>Yearly</div>
            </div>
          </div>
        </div>

        <div class="row">
          <?php
            $arr_product = wc_get_products([
              'status'=> 'publish',
              'limit' => 6,
              'orderby' => 'ID',
              'order' => 'ASC'
            ]); 
           
            $arrProductId = [3027,3028,3029];
            foreach( $arr_product as $product ){
                $class_name = "monthly";
                $display = "";
                if(in_array($product->get_id(), $arrProductId)){                  
                  $class_name = "yearly";
                  $display = "d-none";
                }
             ?>
                <div class="col-xl-4 col-lg-4 col-md-6 <?php echo $class_name . " ". $display; ?>">
                  <div class="single-card text-center mb-30">
                    <div class="card-top">
                      <span><?php echo $product->get_title(); ?></span>
                      <h4>
                        <?php
                          $currency = get_option("woocommerce_currency", true);
                          if( $product->is_type('subscription') ) {  
                            if(!empty($product->get_sale_price())){                        
                              echo "$ ".$product->get_sale_price();
                            } else {
                              echo "$ ".$product->get_regular_price();
                            }
                          }
                         ?>  
                        <span>/ <?php echo $class_name; ?></span>                         
                      </h4>
                      <small><?php echo get_post_meta($product->get_id(), "_rds_website_access_limit", true); ?> website.</small>
                    </div>
                    <div class="card-bottom">
                      <?php $product_details = $product->get_data();
                        echo $product_details['description']; ?>
                      <a href="/checkout/?add-to-cart=<?php  echo $product->get_id(); ?>" class="btn card-btn1" > 
                        Buy Now
                      </a>
                    </div>
                  </div>
                </div>
            <?php }  
            wp_reset_postdata();
          ?> 

        </div>
      </div>
  </div>
</section>
  <!--==========================Footer============================-->
<?php get_footer();?>