<?php /* Template Name: product-shop */
get_header();?>

<div class="wrapper pt-3" id="page-wrapper">
  <section class="sky-blue pt-70 pb-70 m-top">
     <div class="section-tittle text-center">
        <h2 class="m-0 font-size-40"> <?php echo get_the_title();?> </h2>
      </div>
  </section>

  <section class="best-pricing best-pricing2 pricing-padding2">
    <div class="container">
      <div class="row d-flex justify-content-center">
        <div class="col-lg-6 col-md-8">
          <div class="section-tittle text-center">
            <h2><?php if( get_field('pricing_page_title') ): ?>
            <?php the_field('pricing_page_title'); ?>
            <?php endif; ?></h2>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="pricing-card-area price-card">
      <div class="container">
        <div class="row">
          <?php
            $args = array(
              'post_type'   => 'pricing_plan',
              'posts_per_page' => 3,
              'order' => 'ASC'
            );
           $custom_query = new WP_Query( $args );
            if ( $custom_query->have_posts() ) {
              while ( $custom_query->have_posts() ) {
                $custom_query->the_post();

                ?> 
                <div class="col-xl-4 col-lg-4 col-md-6">
                  <div class="single-card text-center mb-30">
                    <div class="card-top">
                      <span><?php the_title(); ?></span>
                      <h4>$<?php if( get_field('price_in') ): ?>
                      <?php the_field('price_in'); ?>
                      <?php endif; ?> <span>/ <?php if( get_field('month_year') ): ?>
                      <?php the_field('month_year'); ?>
                      <?php endif; ?></span></h4>
                    </div>
                    <div class="card-bottom">
                      <?php the_content(); ?>
                      <a href="<?php if( get_field('button_link') ): ?>
                      <?php the_field('button_link'); ?>
                      <?php endif; ?>" class="btn card-btn1"
                      ><?php if( get_field('button_title') ): ?>
                      <?php the_field('button_title'); ?>
                      <?php endif; ?></a
                      >
                    </div>
                  </div>
                </div>
              <?php
              }
            }
            wp_reset_postdata();
          ?> 

        </div>
      </div>
  </section>
</div>
  <!--==========================Footer============================-->
<?php get_footer();?>